/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.router;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.HttpStreamHandler;
import org.wso2.msf4j.HttpStreamer;
import org.wso2.msf4j.Response;
import org.wso2.msf4j.internal.router.HandlerException;

public class HttpMethodInfo {
    private final Method method;
    private final Object handler;
    private final Object[] args;
    private Response responder;
    private HttpStreamHandler httpStreamHandler;
    private static final Logger log = LoggerFactory.getLogger(HttpMethodInfo.class);

    public HttpMethodInfo(Method method, Object handler, Object[] args, Response responder) {
        this.method = method;
        this.handler = handler;
        this.args = Arrays.copyOf(args, args.length);
        this.responder = responder;
    }

    public HttpMethodInfo(Method method, Object handler, Object[] args, Response responder, HttpStreamer httpStreamer) throws HandlerException {
        this(method, handler, args, responder);
        if (!method.getReturnType().equals(Void.TYPE)) {
            throw new HandlerException(Response.Status.INTERNAL_SERVER_ERROR, "Resource method should be void if it accepts chunked requests");
        }
        try {
            method.invoke(handler, args);
        }
        catch (InvocationTargetException e) {
            throw new HandlerException(Response.Status.INTERNAL_SERVER_ERROR, "Resource method invocation failed", e.getTargetException());
        }
        catch (IllegalAccessException e) {
            throw new HandlerException(Response.Status.INTERNAL_SERVER_ERROR, "Resource method invocation access failed", e);
        }
        this.httpStreamHandler = httpStreamer.getHttpStreamHandler();
        if (this.httpStreamHandler == null) {
            throw new HandlerException(Response.Status.INTERNAL_SERVER_ERROR, "Streaming unsupported");
        }
        this.httpStreamHandler.init(this.responder);
    }

    public void invoke() throws Exception {
        Object returnVal = this.method.invoke(this.handler, this.args);
        this.responder.setEntity(returnVal);
        this.responder.send();
    }

    public void chunk(ByteBuffer chunk) throws Exception {
        try {
            this.httpStreamHandler.chunk(chunk);
        }
        catch (Throwable e) {
            log.error("Exception while invoking streaming handlers", e);
            this.httpStreamHandler.error(e);
            throw e;
        }
    }

    public void end() throws Exception {
        try {
            this.httpStreamHandler.end();
        }
        catch (Throwable e) {
            log.error("Exception while invoking streaming handlers", e);
            this.httpStreamHandler.error(e);
            throw e;
        }
    }

    public boolean isStreamingSupported() {
        return this.httpStreamHandler != null;
    }
}

