/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.das.core;

import java.util.Arrays;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.core.MetricManagementService;
import org.wso2.carbon.metrics.core.MetricService;
import org.wso2.carbon.metrics.core.config.MetricsConfigBuilder;
import org.wso2.carbon.metrics.core.reporter.ReporterBuildException;
import org.wso2.carbon.metrics.core.spi.MetricsExtension;
import org.wso2.carbon.metrics.das.core.config.model.DasReporterConfig;
import org.wso2.carbon.metrics.das.core.config.model.MetricsConfig;

@Component(name="org.wso2.carbon.metrics.das.core.DasMetricsExtension", service={MetricsExtension.class}, immediate=true)
public class DasMetricsExtension
implements MetricsExtension {
    private static final Logger logger = LoggerFactory.getLogger(DasMetricsExtension.class);
    private String[] names;

    @Override
    public void activate(MetricService metricService, MetricManagementService metricManagementService) {
        MetricsConfig metricsConfig = MetricsConfigBuilder.build(MetricsConfig.class, MetricsConfig::new);
        Set<DasReporterConfig> dasReporterConfigs = metricsConfig.getReporting().getDas();
        if (dasReporterConfigs != null) {
            dasReporterConfigs.forEach(reporterBuilder -> {
                try {
                    metricManagementService.addReporter(reporterBuilder);
                }
                catch (ReporterBuildException e) {
                    logger.warn("DAS Reporter build failed", e);
                }
            });
            this.names = (String[])dasReporterConfigs.stream().map(dasReporterConfig -> dasReporterConfig.getName()).toArray(String[]::new);
        }
    }

    @Override
    public void deactivate(MetricService metricService, MetricManagementService metricManagementService) {
        if (this.names != null) {
            Arrays.stream(this.names).forEach(metricManagementService::removeReporter);
        }
    }
}

