/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.thrift.TByteArrayOutputStream;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.server.TServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TMemoryInputTransport;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TNonblockingTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNonblockingServer
extends TServer {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass().getName());
    private final long MAX_READ_BUFFER_BYTES;
    private final AtomicLong readBufferBytesAllocated = new AtomicLong(0L);

    public AbstractNonblockingServer(AbstractNonblockingServerArgs args) {
        super(args);
        this.MAX_READ_BUFFER_BYTES = args.maxReadBufferBytes;
    }

    public void serve() {
        if (!this.startThreads()) {
            return;
        }
        if (!this.startListening()) {
            return;
        }
        this.setServing(true);
        this.waitForShutdown();
        this.setServing(false);
        this.stopListening();
    }

    protected abstract boolean startThreads();

    protected abstract void waitForShutdown();

    protected boolean startListening() {
        try {
            this.serverTransport_.listen();
            return true;
        }
        catch (TTransportException ttx) {
            this.LOGGER.error("Failed to start listening on server socket!", ttx);
            return false;
        }
    }

    protected void stopListening() {
        this.serverTransport_.close();
    }

    protected abstract boolean requestInvoke(FrameBuffer var1);

    protected class FrameBuffer {
        private final TNonblockingTransport trans_;
        private final SelectionKey selectionKey_;
        private final AbstractSelectThread selectThread_;
        private FrameBufferState state_ = FrameBufferState.READING_FRAME_SIZE;
        private ByteBuffer buffer_;
        private TByteArrayOutputStream response_;

        public FrameBuffer(TNonblockingTransport trans, SelectionKey selectionKey, AbstractSelectThread selectThread) {
            this.trans_ = trans;
            this.selectionKey_ = selectionKey;
            this.selectThread_ = selectThread;
            this.buffer_ = ByteBuffer.allocate(4);
        }

        public boolean read() {
            if (this.state_ == FrameBufferState.READING_FRAME_SIZE) {
                if (!this.internalRead()) {
                    return false;
                }
                if (this.buffer_.remaining() == 0) {
                    int frameSize = this.buffer_.getInt(0);
                    if (frameSize <= 0) {
                        AbstractNonblockingServer.this.LOGGER.error("Read an invalid frame size of " + frameSize + ". Are you using TFramedTransport on the client side?");
                        return false;
                    }
                    if ((long)frameSize > AbstractNonblockingServer.this.MAX_READ_BUFFER_BYTES) {
                        AbstractNonblockingServer.this.LOGGER.error("Read a frame size of " + frameSize + ", which is bigger than the maximum allowable buffer size for ALL connections.");
                        return false;
                    }
                    if (AbstractNonblockingServer.this.readBufferBytesAllocated.get() + (long)frameSize > AbstractNonblockingServer.this.MAX_READ_BUFFER_BYTES) {
                        return true;
                    }
                    AbstractNonblockingServer.this.readBufferBytesAllocated.addAndGet(frameSize);
                    this.buffer_ = ByteBuffer.allocate(frameSize);
                    this.state_ = FrameBufferState.READING_FRAME;
                } else {
                    return true;
                }
            }
            if (this.state_ == FrameBufferState.READING_FRAME) {
                if (!this.internalRead()) {
                    return false;
                }
                if (this.buffer_.remaining() == 0) {
                    this.selectionKey_.interestOps(0);
                    this.state_ = FrameBufferState.READ_FRAME_COMPLETE;
                }
                return true;
            }
            AbstractNonblockingServer.this.LOGGER.error("Read was called but state is invalid (" + (Object)((Object)this.state_) + ")");
            return false;
        }

        public boolean write() {
            if (this.state_ == FrameBufferState.WRITING) {
                try {
                    if (this.trans_.write(this.buffer_) < 0) {
                        return false;
                    }
                }
                catch (IOException e) {
                    AbstractNonblockingServer.this.LOGGER.warn("Got an IOException during write!", e);
                    return false;
                }
                if (this.buffer_.remaining() == 0) {
                    this.prepareRead();
                }
                return true;
            }
            AbstractNonblockingServer.this.LOGGER.error("Write was called, but state is invalid (" + (Object)((Object)this.state_) + ")");
            return false;
        }

        public void changeSelectInterests() {
            if (this.state_ == FrameBufferState.AWAITING_REGISTER_WRITE) {
                this.selectionKey_.interestOps(4);
                this.state_ = FrameBufferState.WRITING;
            } else if (this.state_ == FrameBufferState.AWAITING_REGISTER_READ) {
                this.prepareRead();
            } else if (this.state_ == FrameBufferState.AWAITING_CLOSE) {
                this.close();
                this.selectionKey_.cancel();
            } else {
                AbstractNonblockingServer.this.LOGGER.error("changeSelectInterest was called, but state is invalid (" + (Object)((Object)this.state_) + ")");
            }
        }

        public void close() {
            if (this.state_ == FrameBufferState.READING_FRAME || this.state_ == FrameBufferState.READ_FRAME_COMPLETE) {
                AbstractNonblockingServer.this.readBufferBytesAllocated.addAndGet(-this.buffer_.array().length);
            }
            this.trans_.close();
        }

        public boolean isFrameFullyRead() {
            return this.state_ == FrameBufferState.READ_FRAME_COMPLETE;
        }

        public void responseReady() {
            AbstractNonblockingServer.this.readBufferBytesAllocated.addAndGet(-this.buffer_.array().length);
            if (this.response_.len() == 0) {
                this.state_ = FrameBufferState.AWAITING_REGISTER_READ;
                this.buffer_ = null;
            } else {
                this.buffer_ = ByteBuffer.wrap(this.response_.get(), 0, this.response_.len());
                this.state_ = FrameBufferState.AWAITING_REGISTER_WRITE;
            }
            this.requestSelectInterestChange();
        }

        public void invoke() {
            TTransport inTrans = this.getInputTransport();
            TProtocol inProt = AbstractNonblockingServer.this.inputProtocolFactory_.getProtocol(inTrans);
            TProtocol outProt = AbstractNonblockingServer.this.outputProtocolFactory_.getProtocol(this.getOutputTransport());
            try {
                AbstractNonblockingServer.this.processorFactory_.getProcessor(inTrans).process(inProt, outProt);
                this.responseReady();
                return;
            }
            catch (TException te) {
                AbstractNonblockingServer.this.LOGGER.warn("Exception while invoking!", te);
            }
            catch (Throwable t) {
                AbstractNonblockingServer.this.LOGGER.error("Unexpected throwable while invoking!", t);
            }
            this.state_ = FrameBufferState.AWAITING_CLOSE;
            this.requestSelectInterestChange();
        }

        private TTransport getInputTransport() {
            return new TMemoryInputTransport(this.buffer_.array());
        }

        private TTransport getOutputTransport() {
            this.response_ = new TByteArrayOutputStream();
            return AbstractNonblockingServer.this.outputTransportFactory_.getTransport(new TIOStreamTransport(this.response_));
        }

        private boolean internalRead() {
            try {
                return this.trans_.read(this.buffer_) >= 0;
            }
            catch (IOException e) {
                AbstractNonblockingServer.this.LOGGER.warn("Got an IOException in internalRead!", e);
                return false;
            }
        }

        private void prepareRead() {
            this.selectionKey_.interestOps(1);
            this.buffer_ = ByteBuffer.allocate(4);
            this.state_ = FrameBufferState.READING_FRAME_SIZE;
        }

        private void requestSelectInterestChange() {
            if (Thread.currentThread() == this.selectThread_) {
                this.changeSelectInterests();
            } else {
                this.selectThread_.requestSelectInterestChange(this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FrameBufferState {
        READING_FRAME_SIZE,
        READING_FRAME,
        READ_FRAME_COMPLETE,
        AWAITING_REGISTER_WRITE,
        WRITING,
        AWAITING_REGISTER_READ,
        AWAITING_CLOSE;

    }

    protected abstract class AbstractSelectThread
    extends Thread {
        protected final Selector selector;
        protected final Set<FrameBuffer> selectInterestChanges = new HashSet<FrameBuffer>();

        public AbstractSelectThread() throws IOException {
            this.selector = SelectorProvider.provider().openSelector();
        }

        public void wakeupSelector() {
            this.selector.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestSelectInterestChange(FrameBuffer frameBuffer) {
            Set<FrameBuffer> set = this.selectInterestChanges;
            synchronized (set) {
                this.selectInterestChanges.add(frameBuffer);
            }
            this.selector.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processInterestChanges() {
            Set<FrameBuffer> set = this.selectInterestChanges;
            synchronized (set) {
                for (FrameBuffer fb : this.selectInterestChanges) {
                    fb.changeSelectInterests();
                }
                this.selectInterestChanges.clear();
            }
        }

        protected void handleRead(SelectionKey key) {
            FrameBuffer buffer = (FrameBuffer)key.attachment();
            if (!buffer.read()) {
                this.cleanupSelectionKey(key);
                return;
            }
            if (buffer.isFrameFullyRead() && !AbstractNonblockingServer.this.requestInvoke(buffer)) {
                this.cleanupSelectionKey(key);
            }
        }

        protected void handleWrite(SelectionKey key) {
            FrameBuffer buffer = (FrameBuffer)key.attachment();
            if (!buffer.write()) {
                this.cleanupSelectionKey(key);
            }
        }

        protected void cleanupSelectionKey(SelectionKey key) {
            FrameBuffer buffer = (FrameBuffer)key.attachment();
            if (buffer != null) {
                buffer.close();
            }
            key.cancel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractNonblockingServerArgs<T extends AbstractNonblockingServerArgs<T>>
    extends TServer.AbstractServerArgs<T> {
        public long maxReadBufferBytes = Long.MAX_VALUE;

        public AbstractNonblockingServerArgs(TNonblockingServerTransport transport) {
            super(transport);
            this.transportFactory(new TFramedTransport.Factory());
        }
    }
}

