/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.deployment.engine.config;

import org.wso2.carbon.deployment.engine.config.DeploymentModeEnum;
import org.wso2.carbon.deployment.engine.config.DeploymentNotifierConfig;
import org.wso2.carbon.kernel.annotations.Configuration;
import org.wso2.carbon.kernel.annotations.Element;
import org.wso2.carbon.kernel.utils.Utils;

@Configuration(namespace="wso2.artifact.deployment", description="Deployment configuration parameters")
public class DeploymentConfiguration {
    @Element(description="deployment mode")
    private DeploymentModeEnum mode = DeploymentModeEnum.scheduled;
    @Element(description="repository location")
    private String repositoryLocation = "${carbon.home}/deployment/";
    @Element(description="Scheduler update interval")
    private int updateInterval = 15;
    @Element(description="Deployment notifier config")
    private DeploymentNotifierConfig deploymentNotifier = new DeploymentNotifierConfig();

    public DeploymentConfiguration() {
        if (Utils.getSystemVariableValue("carbon.home", null) != null) {
            this.repositoryLocation = Utils.substituteVariables(this.repositoryLocation);
        }
    }

    public DeploymentModeEnum getMode() {
        return this.mode;
    }

    public String getRepositoryLocation() {
        return this.repositoryLocation;
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    public DeploymentNotifierConfig getDeploymentNotifier() {
        return this.deploymentNotifier;
    }
}

