/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.core.internal;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.CarbonRuntime;
import org.wso2.carbon.metrics.core.MetricManagementService;
import org.wso2.carbon.metrics.core.MetricService;
import org.wso2.carbon.metrics.core.Metrics;
import org.wso2.carbon.metrics.core.spi.MetricsExtension;
import org.wso2.carbon.metrics.core.utils.Utils;

@Component(name="org.wso2.carbon.metrics.core.internal.MetricsComponent", immediate=true)
public class MetricsComponent {
    private static final Logger logger = LoggerFactory.getLogger(MetricsComponent.class);
    private Metrics metrics;
    private ServiceRegistration metricServiceRegistration;
    private ServiceRegistration metricManagementServiceRegistration;

    @Activate
    protected void activate(BundleContext bundleContext) {
        if (logger.isDebugEnabled()) {
            logger.debug("Metrics Component activated");
        }
        Utils.setCarbonEnvironment(true);
        this.metrics = new Metrics();
        this.metrics.activate();
        this.metricServiceRegistration = bundleContext.registerService(MetricService.class, (Object)this.metrics.getMetricService(), null);
        this.metricManagementServiceRegistration = bundleContext.registerService(MetricManagementService.class, (Object)this.metrics.getMetricManagementService(), null);
    }

    @Deactivate
    protected void deactivate() {
        if (logger.isDebugEnabled()) {
            logger.debug("Metrics Component deactivated");
        }
        this.metrics.deactivate();
        this.metricServiceRegistration.unregister();
        this.metricManagementServiceRegistration.unregister();
    }

    @Reference(name="carbon.runtime.service", service=CarbonRuntime.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetCarbonRuntime")
    protected void setCarbonRuntime(CarbonRuntime carbonRuntime) {
        if (logger.isDebugEnabled()) {
            logger.debug("Setting default source to {}", (Object)carbonRuntime.getConfiguration().getId());
        }
        Utils.setDefaultSource(carbonRuntime.getConfiguration().getId());
    }

    protected void unsetCarbonRuntime(CarbonRuntime carbonRuntime) {
        if (logger.isDebugEnabled()) {
            logger.debug("The Carbon Runtime is unregistered");
        }
    }

    @Reference(name="carbon.metrics.extension", service=MetricsExtension.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetMetricsExtension")
    protected void setMetricsExtension(MetricsExtension metricsExtension) {
        if (logger.isDebugEnabled()) {
            logger.debug("Activating Metrics Extension {}", (Object)metricsExtension.getClass().getName());
        }
        metricsExtension.activate(this.metrics.getMetricService(), this.metrics.getMetricManagementService());
    }

    protected void unsetMetricsExtension(MetricsExtension metricsExtension) {
        if (logger.isDebugEnabled()) {
            logger.debug("Deactivating Metrics Extension {}", (Object)metricsExtension.getClass().getName());
        }
        metricsExtension.deactivate(this.metrics.getMetricService(), this.metrics.getMetricManagementService());
    }
}

