/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.core.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);
    private static volatile String defaultSource;
    private static volatile boolean carbonEnvironment;

    public static String getDefaultSource() {
        if (defaultSource == null) {
            String hostname = null;
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            defaultSource = hostname == null || hostname.trim().length() == 0 ? "Carbon" : hostname;
        }
        return defaultSource;
    }

    public static void setDefaultSource(String defaultSource) {
        Utils.defaultSource = defaultSource;
    }

    public static boolean isCarbonEnvironment() {
        return carbonEnvironment;
    }

    public static void setCarbonEnvironment(boolean carbonEnvironment) {
        Utils.carbonEnvironment = carbonEnvironment;
    }

    public static Optional<File> getConfigFile(String key, String fileName) {
        File file = new File(System.getProperty(key, fileName));
        if (!file.exists() && carbonEnvironment) {
            file = new File(org.wso2.carbon.kernel.utils.Utils.getCarbonConfigHome().resolve(fileName).toString());
        }
        if (file.exists() && file.isFile()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Configuration file found at {}", (Object)file.getAbsolutePath());
            }
            return Optional.of(file);
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<Properties> loadProperties(String key, String fileName) {
        Optional<File> configFile = Utils.getConfigFile(key, fileName);
        try (InputStream in = configFile.isPresent() ? new FileInputStream(configFile.get()) : Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);){
            if (in != null) {
                Properties properties = new Properties();
                properties.load(in);
                Optional<Properties> optional = Optional.of(properties);
                return optional;
            }
            Optional<Properties> optional = Optional.empty();
            return optional;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read properties from the file: " + fileName, e);
        }
    }

    /*
     * Exception decompiling
     */
    public static Optional<String> readFile(String key, String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

