/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.listener;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonTransportInitializer;
import org.wso2.carbon.transport.http.netty.common.ssl.SSLConfig;
import org.wso2.carbon.transport.http.netty.common.ssl.SSLHandlerFactory;
import org.wso2.carbon.transport.http.netty.config.ListenerConfiguration;
import org.wso2.carbon.transport.http.netty.config.RequestSizeValidationConfiguration;
import org.wso2.carbon.transport.http.netty.listener.CustomHttpObjectAggregator;
import org.wso2.carbon.transport.http.netty.listener.CustomHttpRequestDecoder;
import org.wso2.carbon.transport.http.netty.listener.SourceHandler;
import org.wso2.carbon.transport.http.netty.sender.channel.pool.ConnectionManager;

@Deprecated
public class CarbonHTTPServerInitializer
extends ChannelInitializer<SocketChannel>
implements CarbonTransportInitializer {
    private static final Logger log = LoggerFactory.getLogger(CarbonHTTPServerInitializer.class);
    private ConnectionManager connectionManager;
    private Map<String, ListenerConfiguration> listenerConfigurationMap;
    private SSLConfig sslConfig;
    private Map<String, SSLConfig> sslConfigMap;

    public CarbonHTTPServerInitializer(Map<String, ListenerConfiguration> integerListenerConfigurationMap) {
        this.listenerConfigurationMap = integerListenerConfigurationMap;
    }

    @Override
    public void setup(Map<String, String> parameters) {
    }

    public void setupConnectionManager(Map<String, Object> transportProperties) {
        try {
            this.connectionManager = ConnectionManager.getInstance(transportProperties);
        }
        catch (Exception e) {
            log.error("Error initializing the transport ", e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void initChannel(SocketChannel ch) throws Exception {
        SslHandler sslHandler;
        if (log.isDebugEnabled()) {
            log.debug("Initializing source channel pipeline");
        }
        int port = ch.localAddress().getPort();
        String id = String.valueOf(port);
        ListenerConfiguration listenerConfiguration = this.listenerConfigurationMap.get(id);
        if (this.sslConfigMap.get(id) != null) {
            sslHandler = new SSLHandlerFactory(this.sslConfigMap.get(id)).create();
            ch.pipeline().addLast("ssl", (ChannelHandler)sslHandler);
        } else if (this.sslConfig != null) {
            sslHandler = new SSLHandlerFactory(this.sslConfig).create();
            ch.pipeline().addLast("ssl", (ChannelHandler)sslHandler);
        }
        ChannelPipeline p = ch.pipeline();
        p.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        if (RequestSizeValidationConfiguration.getInstance().isHeaderSizeValidation()) {
            p.addLast("decoder", (ChannelHandler)new CustomHttpRequestDecoder());
        } else {
            p.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        }
        if (RequestSizeValidationConfiguration.getInstance().isRequestSizeValidation()) {
            p.addLast("custom-aggregator", (ChannelHandler)new CustomHttpObjectAggregator());
        }
        p.addLast("compressor", (ChannelHandler)new HttpContentCompressor());
        p.addLast("chunkWriter", (ChannelHandler)new ChunkedWriteHandler());
        try {
            p.addLast("handler", (ChannelHandler)new SourceHandler(this.connectionManager, listenerConfiguration));
        }
        catch (Exception e) {
            log.error("Cannot Create SourceHandler ", e);
        }
    }

    @Override
    public boolean isServerInitializer() {
        return true;
    }

    public void setSslConfig(SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
    }

    public void setSslConfigMap(Map<String, SSLConfig> sslConfigMap) {
        this.sslConfigMap = sslConfigMap;
    }
}

