/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.listener;

import io.netty.channel.ChannelFuture;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.carbon.messaging.ServerConnector;
import org.wso2.carbon.messaging.exceptions.ServerConnectorException;
import org.wso2.carbon.transport.http.netty.config.ListenerConfiguration;
import org.wso2.carbon.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.carbon.transport.http.netty.listener.ServerConnectorController;

public class HTTPServerConnector
extends ServerConnector {
    private static final Logger log = LoggerFactory.getLogger(HTTPServerConnector.class);
    private ChannelFuture channelFuture;
    private ListenerConfiguration listenerConfiguration;
    private ServerConnectorController serverConnectorController;

    public HTTPServerConnector(String id) {
        super(id, Collections.emptyMap());
    }

    @Override
    public void start() throws ServerConnectorException {
        if (this.listenerConfiguration.isBindOnStartup()) {
            return;
        }
        this.serverConnectorController.bindInterface(this);
    }

    @Override
    public void stop() {
        this.serverConnectorController.unBindInterface(this);
    }

    @Override
    public void beginMaintenance() {
    }

    @Override
    public void endMaintenance() {
    }

    @Override
    public void setMessageProcessor(CarbonMessageProcessor carbonMessageProcessor) {
        HTTPTransportContextHolder.getInstance().setMessageProcessor(carbonMessageProcessor);
    }

    @Override
    public void init() throws ServerConnectorException {
        log.info("Initializing HTTP Transport Listener");
    }

    @Override
    protected void destroy() throws ServerConnectorException {
        log.info("Destroying HTTP Transport Listener");
    }

    public ChannelFuture getChannelFuture() {
        return this.channelFuture;
    }

    public void setChannelFuture(ChannelFuture channelFuture) {
        this.channelFuture = channelFuture;
    }

    public ListenerConfiguration getListenerConfiguration() {
        return this.listenerConfiguration;
    }

    public void setListenerConfiguration(ListenerConfiguration listenerConfiguration) {
        this.listenerConfiguration = listenerConfiguration;
    }

    public void setServerConnectorController(ServerConnectorController serverConnectorController) {
        this.serverConnectorController = serverConnectorController;
    }

    public ServerConnectorController getServerConnectorController() {
        return this.serverConnectorController;
    }

    public String toString() {
        return this.listenerConfiguration.getScheme() + "-" + this.listenerConfiguration.getPort();
    }
}

