/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.listener;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.wso2.carbon.messaging.ServerConnector;
import org.wso2.carbon.messaging.ServerConnectorProvider;
import org.wso2.carbon.transport.http.netty.config.ConfigurationBuilder;
import org.wso2.carbon.transport.http.netty.config.ListenerConfiguration;
import org.wso2.carbon.transport.http.netty.config.TransportsConfiguration;
import org.wso2.carbon.transport.http.netty.listener.HTTPServerConnector;
import org.wso2.carbon.transport.http.netty.listener.ServerConnectorController;

@Component(name="org.wso2.carbon.transport.http.netty.listener.HTTPServerConnectorProvider", immediate=true, service={ServerConnectorProvider.class})
public class HTTPServerConnectorProvider
extends ServerConnectorProvider {
    public HTTPServerConnectorProvider() {
        super("http");
    }

    public List<ServerConnector> initializeConnectors(TransportsConfiguration trpConfig) {
        ArrayList<ServerConnector> connectors = new ArrayList<ServerConnector>();
        ServerConnectorController serverConnectorController = new ServerConnectorController(trpConfig);
        serverConnectorController.start();
        Set<ListenerConfiguration> listenerConfigurationSet = trpConfig.getListenerConfigurations();
        listenerConfigurationSet.forEach(config -> {
            HTTPServerConnector connector = new HTTPServerConnector(config.getId());
            connector.setListenerConfiguration((ListenerConfiguration)config);
            connector.setServerConnectorController(serverConnectorController);
            if (config.isBindOnStartup()) {
                serverConnectorController.bindInterface(connector);
            }
            connectors.add(connector);
        });
        return connectors;
    }

    @Override
    public List<ServerConnector> initializeConnectors() {
        return this.initializeConnectors(ConfigurationBuilder.getInstance().getConfiguration());
    }

    @Override
    public ServerConnector createConnector(String id, Map<String, String> properties) {
        return null;
    }
}

