/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.config;

import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.wso2.carbon.config.annotation.Configuration;

@SupportedAnnotationTypes(value={"org.wso2.carbon.config.annotation.Configuration"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class ConfigurationProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> configSet = roundEnv.getElementsAnnotatedWith(Configuration.class);
        StringBuilder builder = new StringBuilder();
        for (Element element : configSet) {
            Configuration configuration = element.getAnnotation(Configuration.class);
            if (configuration == null || "NULL".equals(configuration.namespace())) continue;
            builder.append(((TypeElement)element).getQualifiedName()).append(",");
        }
        if (builder.length() > 0) {
            try {
                FileObject file = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "temp_config_classnames.txt", new Element[0]);
                try (Writer writer = file.openWriter();){
                    writer.write(builder.toString());
                }
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            }
        } else {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Configuration classes doesn't exist in the project");
        }
        return true;
    }
}

