/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.carbon.config.ConfigProviderFactory;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.databridge.agent.DataEndpointAgent;
import org.wso2.carbon.databridge.agent.conf.Agent;
import org.wso2.carbon.databridge.agent.conf.AgentConfiguration;
import org.wso2.carbon.databridge.agent.conf.DataAgentConfigurationFileResolver;
import org.wso2.carbon.databridge.agent.conf.DataAgentsConfiguration;
import org.wso2.carbon.databridge.agent.exception.DataEndpointAgentConfigurationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointException;
import org.wso2.carbon.databridge.agent.internal.DataAgentServiceValueHolder;

public class AgentHolder {
    private static final Logger log = Logger.getLogger(AgentHolder.class);
    private static String configPath;
    private static AgentHolder instance;
    private Map<String, DataEndpointAgent> dataEndpointAgents;
    private String defaultDataEndpointAgentName;

    private AgentHolder() throws DataEndpointAgentConfigurationException {
        try {
            this.dataEndpointAgents = new HashMap<String, DataEndpointAgent>();
            DataAgentsConfiguration dataAgentsConfiguration = this.loadConfiguration();
            boolean isDefault = true;
            for (Agent agent : dataAgentsConfiguration.getAgents()) {
                this.addAgentConfiguration(agent.getAgentConfiguration(), isDefault);
                if (!isDefault) continue;
                isDefault = false;
            }
        }
        catch (DataEndpointAgentConfigurationException e) {
            log.error("Unable to complete initialization of agents." + e.getMessage(), e);
            throw e;
        }
    }

    public static synchronized AgentHolder getInstance() throws DataEndpointAgentConfigurationException {
        if (instance == null) {
            instance = new AgentHolder();
        }
        return instance;
    }

    public static void setConfigPath(String configPath) {
        AgentHolder.configPath = configPath;
    }

    public static synchronized void shutdown() throws DataEndpointException {
        if (instance != null) {
            for (DataEndpointAgent dataEndpointAgent : AgentHolder.instance.dataEndpointAgents.values()) {
                dataEndpointAgent.shutDown();
            }
            instance = null;
        }
    }

    public synchronized DataEndpointAgent getDataEndpointAgent(String type) throws DataEndpointAgentConfigurationException {
        DataEndpointAgent agent = this.dataEndpointAgents.get(type.toLowerCase());
        if (agent == null) {
            throw new DataEndpointAgentConfigurationException("No data agent configured for the type: " + type.toLowerCase());
        }
        return agent;
    }

    private DataAgentsConfiguration loadConfiguration() throws DataEndpointAgentConfigurationException {
        try {
            DataAgentsConfiguration dataAgentsConfiguration = null;
            if (configPath == null) {
                ConfigProvider configProvider = DataAgentServiceValueHolder.getConfigProvider();
                if (configProvider != null) {
                    dataAgentsConfiguration = DataAgentConfigurationFileResolver.resolveAndSetDataAgentConfiguration((LinkedHashMap)configProvider.getConfigurationObject("data.agent.config"));
                }
            } else {
                try {
                    Path dataAgentConfigPath = Paths.get(configPath, new String[0]);
                    if (!Files.exists(dataAgentConfigPath, new LinkOption[0])) {
                        throw new DataEndpointAgentConfigurationException("Cannot find the databridge agent configuration file in the specified path");
                    }
                    ConfigProvider configProvider = ConfigProviderFactory.getConfigProvider(dataAgentConfigPath);
                    dataAgentsConfiguration = DataAgentConfigurationFileResolver.resolveAndSetDataAgentConfiguration((LinkedHashMap)configProvider.getConfigurationObject("data.agent.config"));
                }
                catch (ConfigurationException e) {
                    throw new DataEndpointAgentConfigurationException("Error in when loading databridge agent configuration", e);
                }
            }
            if (dataAgentsConfiguration != null) {
                for (Agent agent : dataAgentsConfiguration.getAgents()) {
                    AgentConfiguration agentConfiguration = agent.getAgentConfiguration();
                    if (agentConfiguration.getTrustStorePath() == null || agentConfiguration.getTrustStorePath().isEmpty()) {
                        agentConfiguration.setTrustStorePath(System.getProperty("javax.net.ssl.trustStore"));
                        if (agentConfiguration.getTrustStorePath() == null) {
                            throw new DataEndpointAgentConfigurationException("No trustStore found");
                        }
                    }
                    if (agentConfiguration.getTrustStorePassword() != null && !agentConfiguration.getTrustStorePassword().isEmpty()) continue;
                    agentConfiguration.setTrustStorePassword(System.getProperty("javax.net.ssl.trustStorePassword"));
                    if (agentConfiguration.getTrustStorePassword() != null) continue;
                    throw new DataEndpointAgentConfigurationException("No trustStore password found");
                }
            }
            return dataAgentsConfiguration;
        }
        catch (Exception e) {
            throw new DataEndpointAgentConfigurationException("Error while loading the configuration file " + configPath, e);
        }
    }

    private void addAgentConfiguration(AgentConfiguration agentConfiguration, boolean defaultAgent) throws DataEndpointAgentConfigurationException {
        DataEndpointAgent agent = new DataEndpointAgent(agentConfiguration);
        this.dataEndpointAgents.put(agent.getAgentConfiguration().getName().toLowerCase(), agent);
        if (defaultAgent) {
            this.defaultDataEndpointAgentName = agent.getAgentConfiguration().getName();
        }
    }

    public DataEndpointAgent getDefaultDataEndpointAgent() throws DataEndpointAgentConfigurationException {
        return this.getDataEndpointAgent(this.defaultDataEndpointAgentName);
    }
}

