/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent.endpoint.binary;

import java.io.IOException;
import java.net.Socket;
import org.apache.log4j.Logger;
import org.wso2.carbon.databridge.agent.AgentHolder;
import org.wso2.carbon.databridge.agent.client.AbstractClientPoolFactory;
import org.wso2.carbon.databridge.agent.conf.DataEndpointConfiguration;
import org.wso2.carbon.databridge.agent.exception.DataEndpointAgentConfigurationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointException;

public class BinaryClientPoolFactory
extends AbstractClientPoolFactory {
    private static final Logger log = Logger.getLogger(BinaryClientPoolFactory.class);

    @Override
    public Object createClient(String protocol, String hostName, int port) throws DataEndpointException, DataEndpointAgentConfigurationException {
        if (protocol.equalsIgnoreCase(DataEndpointConfiguration.Protocol.TCP.toString())) {
            int timeout = AgentHolder.getInstance().getDataEndpointAgent("BINARY").getAgentConfiguration().getSocketTimeoutMS();
            try {
                Socket socket = new Socket(hostName, port);
                socket.setSoTimeout(timeout);
                return socket;
            }
            catch (IOException e) {
                throw new DataEndpointException("Error while opening socket to " + hostName + ":" + port + ". " + e.getMessage(), e);
            }
        }
        throw new DataEndpointException("Unsupported protocol: " + protocol + ". Currently only " + DataEndpointConfiguration.Protocol.TCP.toString() + " supported.");
    }

    @Override
    public boolean validateClient(Object client) {
        return ((Socket)client).isConnected();
    }

    @Override
    public void terminateClient(Object client) {
        Socket socket = null;
        try {
            socket = (Socket)client;
            socket.close();
        }
        catch (IOException e) {
            log.warn("Cannot close the socket successfully from " + socket.getLocalAddress().getHostAddress() + ":" + socket.getPort());
        }
    }
}

