/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.core.impl;

import java.util.List;
import org.wso2.carbon.metrics.core.Counter;

public class CounterCollection
implements Counter {
    private final Counter counter;
    private final List<Counter> affected;

    public CounterCollection(Counter counter, List<Counter> affectedCounters) {
        this.counter = counter;
        this.affected = affectedCounters;
    }

    @Override
    public void inc() {
        this.counter.inc();
        for (Counter c : this.affected) {
            c.inc();
        }
    }

    @Override
    public void inc(long n) {
        this.counter.inc(n);
        for (Counter c : this.affected) {
            c.inc(n);
        }
    }

    @Override
    public void dec() {
        this.counter.dec();
        for (Counter c : this.affected) {
            c.dec();
        }
    }

    @Override
    public void dec(long n) {
        this.counter.dec(n);
        for (Counter c : this.affected) {
            c.dec(n);
        }
    }

    @Override
    public long getCount() {
        return this.counter.getCount();
    }
}

