/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.sample.metrics.service;

import java.util.Random;
import java.util.concurrent.atomic.LongAdder;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.wso2.carbon.metrics.core.annotation.Counted;
import org.wso2.carbon.metrics.core.annotation.Metered;
import org.wso2.carbon.metrics.core.annotation.Timed;

@Path(value="/demo")
public class DemoService {
    private final Random random = new Random();
    private final LongAdder longAdder = new LongAdder();

    @GET
    @Path(value="/rand/{bound}")
    @Metered
    public int getRandomInt(@PathParam(value="bound") int bound) {
        return this.random.nextInt(bound);
    }

    @GET
    @Path(value="/echo/{string}")
    @Timed
    public String echo(@PathParam(value="string") String string) {
        try {
            Thread.sleep(this.random.nextInt(5000));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return string;
    }

    @GET
    @Path(value="/count/{number}")
    @Counted(monotonic=true)
    public long getCount(@PathParam(value="number") long number) {
        this.longAdder.add(number);
        return this.longAdder.longValue();
    }
}

