/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.core.impl;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.core.Level;
import org.wso2.carbon.metrics.core.MetricManagementService;
import org.wso2.carbon.metrics.core.impl.MetricManager;
import org.wso2.carbon.metrics.core.reporter.ListeningReporter;
import org.wso2.carbon.metrics.core.reporter.Reporter;
import org.wso2.carbon.metrics.core.reporter.ReporterBuildException;
import org.wso2.carbon.metrics.core.reporter.ReporterBuilder;
import org.wso2.carbon.metrics.core.reporter.ScheduledReporter;

public class MetricManagementServiceImpl
implements MetricManagementService {
    private static final Logger logger = LoggerFactory.getLogger(MetricManagementServiceImpl.class);
    private final MetricManager metricManager;
    private final Map<String, Reporter> reporterMap = new ConcurrentHashMap<String, Reporter>();

    public MetricManagementServiceImpl(MetricManager metricManager) {
        this.metricManager = metricManager;
        metricManager.addEnabledStatusChangeListener(enabled -> {
            if (enabled) {
                this.startReporters();
            } else {
                this.stopReporters();
            }
        });
        metricManager.addRootLevelChangeListener((oldLevel, newLevel) -> this.restartListeningReporters());
        metricManager.addMetricLevelChangeListener((metric, oldLevel, newLevel) -> this.restartListeningReporters());
    }

    @Override
    public Level getRootLevel() {
        return this.metricManager.getRootLevel();
    }

    @Override
    public void setRootLevel(Level level) {
        this.metricManager.setRootLevel(level);
    }

    @Override
    public boolean isEnabled() {
        return this.metricManager.isEnabled();
    }

    @Override
    public void enable() {
        this.metricManager.enable();
    }

    @Override
    public void disable() {
        this.metricManager.disable();
    }

    @Override
    public long getMetricsCount() {
        return this.metricManager.getMetricsCount();
    }

    @Override
    public long getEnabledMetricsCount() {
        return this.metricManager.getEnabledMetricsCount();
    }

    @Override
    public long getMetricCollectionsCount() {
        return this.metricManager.getMetricCollectionsCount();
    }

    @Override
    public void setMetricLevel(String name, Level level) {
        this.metricManager.setMetricLevel(name, level);
    }

    @Override
    public Level getMetricLevel(String name) {
        return this.metricManager.getMetricLevel(name);
    }

    @Override
    public <T extends ReporterBuilder> void addReporter(T reporterBuilder) throws ReporterBuildException {
        Optional<Reporter> reporter = reporterBuilder.build(this.metricManager.getMetricRegistry(), this.metricManager.getEnabledMetricFilter());
        reporter.ifPresent(newReporter -> {
            Reporter previousReporter;
            if (this.isEnabled()) {
                newReporter.start();
            }
            if ((previousReporter = this.reporterMap.put(newReporter.getName(), (Reporter)newReporter)) != null) {
                previousReporter.stop();
            }
        });
    }

    @Override
    public boolean removeReporter(String name) {
        Reporter previousReporter = this.reporterMap.remove(name);
        if (previousReporter != null) {
            previousReporter.stop();
            return true;
        }
        return false;
    }

    @Override
    public void report() {
        this.reporterMap.values().stream().filter(reporter -> reporter instanceof ScheduledReporter).forEach(reporter -> ((ScheduledReporter)reporter).report());
    }

    @Override
    public void report(String name) {
        this.reporterMap.values().stream().filter(reporter -> name.equals(reporter.getName())).filter(reporter -> reporter instanceof ScheduledReporter).forEach(reporter -> ((ScheduledReporter)reporter).report());
    }

    private Reporter getReporter(String name) {
        Reporter reporter = this.reporterMap.get(name);
        if (reporter == null) {
            throw new IllegalArgumentException("Invalid Reporter Name");
        }
        return reporter;
    }

    @Override
    public void startReporter(String name) {
        this.getReporter(name).start();
    }

    @Override
    public void stopReporter(String name) {
        this.getReporter(name).stop();
    }

    @Override
    public boolean isReporterRunning(String name) {
        return this.getReporter(name).isRunning();
    }

    @Override
    public void startReporters() {
        this.reporterMap.values().forEach(reporter -> {
            try {
                reporter.start();
            }
            catch (Throwable e) {
                logger.error("Error when starting the reporter", e);
            }
        });
    }

    @Override
    public void stopReporters() {
        this.reporterMap.values().forEach(reporter -> {
            try {
                reporter.stop();
            }
            catch (Throwable e) {
                logger.error("Error when stopping the reporter", e);
            }
        });
    }

    private void restartListeningReporters() {
        this.reporterMap.values().stream().filter(reporter -> reporter instanceof ListeningReporter).filter(Reporter::isRunning).forEach(reporter -> {
            ListeningReporter listeningReporter = (ListeningReporter)reporter;
            listeningReporter.stop();
            listeningReporter.start();
        });
    }
}

