/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.listener.states;

import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contract.ServerConnectorException;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contract.config.ChunkConfig;
import org.wso2.transport.http.netty.contractimpl.HttpOutboundRespListener;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.common.states.MessageStateContext;
import org.wso2.transport.http.netty.contractimpl.common.states.StateUtil;
import org.wso2.transport.http.netty.contractimpl.listener.SourceHandler;
import org.wso2.transport.http.netty.contractimpl.listener.states.ReceivingEntityBody;
import org.wso2.transport.http.netty.contractimpl.listener.states.SendingHeaders;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class Response100ContinueSent
extends SendingHeaders {
    private static final Logger LOG = LoggerFactory.getLogger(Response100ContinueSent.class);
    private final MessageStateContext messageStateContext;
    private final HttpOutboundRespListener outboundResponseListener;
    private final SourceHandler sourceHandler;
    private final float httpVersion;

    Response100ContinueSent(HttpOutboundRespListener outboundResponseListener, SourceHandler sourceHandler, MessageStateContext messageStateContext) {
        super(outboundResponseListener, messageStateContext);
        this.outboundResponseListener = outboundResponseListener;
        this.chunkConfig = outboundResponseListener.getChunkConfig();
        this.keepAlive = outboundResponseListener.isKeepAlive();
        this.sourceHandler = sourceHandler;
        this.messageStateContext = messageStateContext;
        this.httpVersion = Float.parseFloat(outboundResponseListener.getRequestDataHolder().getHttpVersion());
    }

    @Override
    public void readInboundRequestHeaders(HttpCarbonMessage inboundRequestMsg, HttpRequest inboundRequestHeaders) {
        LOG.warn("readInboundRequestHeaders {}", (Object)"is not a dependant action of this state");
    }

    @Override
    public void readInboundRequestBody(Object inboundRequestEntityBody) throws ServerConnectorException {
        this.messageStateContext.setListenerState(new ReceivingEntityBody(this.messageStateContext, this.outboundResponseListener.getInboundRequestMsg(), this.sourceHandler, this.httpVersion));
        this.messageStateContext.getListenerState().readInboundRequestBody(inboundRequestEntityBody);
    }

    @Override
    public void writeOutboundResponseHeaders(HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) {
        LOG.warn("writeOutboundResponseHeaders {}", (Object)"is not a dependant action of this state");
    }

    @Override
    public void writeOutboundResponseBody(HttpOutboundRespListener outboundRespListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) {
        ChunkConfig responseChunkConfig;
        ChunkConfig chunkConfig = responseChunkConfig = outboundResponseMsg.getProperty("chunking_config") != null ? (ChunkConfig)((Object)outboundResponseMsg.getProperty("chunking_config")) : null;
        if (responseChunkConfig != null) {
            super.setChunkConfig(responseChunkConfig);
        }
        this.outboundRespStatusFuture = this.outboundResponseListener.getInboundRequestMsg().getHttpOutboundRespStatusFuture();
        if (this.chunkConfig == ChunkConfig.ALWAYS && StateUtil.checkChunkingCompatibility(String.valueOf(this.httpVersion), this.chunkConfig)) {
            Util.setupChunkedRequest(outboundResponseMsg);
            ChannelFuture outboundHeaderFuture = this.writeResponseHeaders(outboundResponseMsg, this.keepAlive);
            StateUtil.notifyIfHeaderWriteFailure(this.outboundRespStatusFuture, outboundHeaderFuture, "Remote client closed the connection before initiating outbound response");
        } else {
            CompositeByteBuf allContent = Unpooled.compositeBuffer();
            allContent.addComponent(true, httpContent.content());
            HttpResponse fullOutboundResponse = Util.createFullHttpResponse(outboundResponseMsg, outboundRespListener.getRequestDataHolder().getHttpVersion(), outboundRespListener.getServerName(), outboundRespListener.isKeepAlive(), allContent);
            ChannelFuture outboundHeaderFuture = outboundRespListener.getSourceContext().writeAndFlush(fullOutboundResponse);
            this.checkForResponseWriteStatus(outboundRespListener.getInboundRequestMsg(), this.outboundRespStatusFuture, outboundHeaderFuture);
        }
    }

    @Override
    public void handleAbruptChannelClosure(ServerConnectorFuture serverConnectorFuture) {
        LOG.error("Remote client closed the connection while writing 100 continue response");
    }

    @Override
    public ChannelFuture handleIdleTimeoutConnectionClosure(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext ctx) {
        LOG.error("Idle timeout triggered while writing 100 continue response");
        return null;
    }

    private void checkForResponseWriteStatus(HttpCarbonMessage inboundRequestMsg, HttpResponseFuture outboundRespStatusFuture, ChannelFuture channelFuture) {
        channelFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)writeOperationPromise -> {
            Throwable throwable = writeOperationPromise.cause();
            if (throwable != null) {
                if (throwable instanceof ClosedChannelException) {
                    throwable = new IOException("Connection between remote client and host is closed");
                }
                outboundRespStatusFuture.notifyHttpListener(throwable);
            } else {
                outboundRespStatusFuture.notifyHttpListener(inboundRequestMsg);
            }
        }));
    }
}

