/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.context;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class CarbonContextHolder {
    private Principal userPrincipal;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private static ThreadLocal<CarbonContextHolder> currentContextHolder = new ThreadLocal<CarbonContextHolder>(){

        @Override
        protected CarbonContextHolder initialValue() {
            return new CarbonContextHolder();
        }
    };

    private CarbonContextHolder() {
    }

    public static CarbonContextHolder getCurrentContextHolder() {
        return currentContextHolder.get();
    }

    public void destroyCurrentCarbonContextHolder() {
        currentContextHolder.remove();
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public void setUserPrincipal(Principal userPrincipal) {
        if (this.userPrincipal == null) {
            this.userPrincipal = userPrincipal;
        } else {
            Optional.ofNullable(this.userPrincipal.getName()).filter(name -> userPrincipal.getName().equals(name)).orElseThrow(() -> new IllegalStateException("Trying to override the already available user principal from " + this.userPrincipal.toString() + " to " + userPrincipal.toString()));
        }
    }
}

