/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.messaging;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonMessage;

public class TextCarbonMessage
extends CarbonMessage {
    private static final Logger LOG = LoggerFactory.getLogger(TextCarbonMessage.class);
    private final String text;

    public TextCarbonMessage(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public InputStream getInputStream() {
        if (this.text == null) {
            return null;
        }
        return new ByteArrayInputStream(this.text.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public ByteBuffer getMessageBody() {
        this.setEndOfMsgAdded(true);
        try {
            return ByteBuffer.wrap(this.text.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Couldn't get the byteBuffer from string payload");
            return null;
        }
    }
}

