/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.CarbonRuntime;
import org.wso2.carbon.kernel.internal.DataHolder;
import org.wso2.carbon.kernel.internal.config.YAMLBasedConfigProvider;
import org.wso2.carbon.kernel.internal.context.CarbonRuntimeFactory;
import org.wso2.carbon.kernel.utils.MBeanRegistrator;

public class CarbonCoreBundleActivator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(CarbonCoreBundleActivator.class);

    public void start(BundleContext bundleContext) throws Exception {
        DataHolder.getInstance().setBundleContext(bundleContext);
        YAMLBasedConfigProvider configProvider = new YAMLBasedConfigProvider();
        CarbonRuntime carbonRuntime = CarbonRuntimeFactory.createCarbonRuntime(configProvider);
        bundleContext.registerService(CarbonRuntime.class.getName(), (Object)carbonRuntime, null);
        DataHolder.getInstance().setCarbonRuntime(carbonRuntime);
        logger.debug("Carbon core bundle is started successfully");
    }

    public void stop(BundleContext bundleContext) throws Exception {
        MBeanRegistrator.unregisterAllMBeans();
        logger.debug("Carbon core bundle is stopped successfully");
    }
}

