/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.router;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.wso2.msf4j.HttpStreamer;
import org.wso2.msf4j.formparam.FormDataParam;
import org.wso2.msf4j.internal.router.ParamConvertUtils;
import org.wso2.msf4j.internal.router.SubresourceKey;
import org.wso2.msf4j.util.Utils;

public final class HttpResourceModel {
    private static final Set<Class<? extends Annotation>> SUPPORTED_PARAM_ANNOTATIONS;
    private static final String[] ANY_MEDIA_TYPE;
    private static final int STREAMING_REQ_UNKNOWN = 0;
    private static final int STREAMING_REQ_SUPPORTED = 1;
    private static final int STREAMING_REQ_UNSUPPORTED = 2;
    private final Set<String> httpMethods;
    private final String path;
    private final Method method;
    private final Object handler;
    private final List<ParameterInfo<?>> paramInfoList;
    private List<String> consumesMediaTypes;
    private List<String> producesMediaTypes;
    private int isStreamingReqSupported = 0;
    private Map<SubresourceKey, HttpResourceModel> subResources = new HashMap<SubresourceKey, HttpResourceModel>();
    private boolean isSubResourceLocator;
    private boolean isSubResourceScanned;
    private HttpResourceModel parent;

    public HttpResourceModel getParent() {
        return this.parent;
    }

    public void setParent(HttpResourceModel parent) {
        this.parent = parent;
        this.consumesMediaTypes = this.parseConsumesMediaTypes();
        this.producesMediaTypes = this.parseProducesMediaTypes();
    }

    public Map<SubresourceKey, HttpResourceModel> getSubResources() {
        return this.subResources;
    }

    public void setSubResources(Map<SubresourceKey, HttpResourceModel> subResources) {
        this.subResources = subResources;
    }

    public void addSubResources(SubresourceKey subresourceKey, HttpResourceModel httpResourceModel) {
        this.subResources.put(subresourceKey, httpResourceModel);
    }

    public void setSubResourceScanned(boolean subResourceScanned) {
        this.isSubResourceScanned = subResourceScanned;
    }

    public boolean isSubResourceScanned() {
        return this.isSubResourceScanned;
    }

    public HttpResourceModel(String path, Method method, Object handler, boolean isSubResourceLocator) {
        this.httpMethods = this.getHttpMethods(method);
        this.path = path;
        this.method = method;
        this.handler = handler;
        this.isSubResourceLocator = isSubResourceLocator;
        this.paramInfoList = this.makeParamInfoList(method);
        this.consumesMediaTypes = this.parseConsumesMediaTypes();
        this.producesMediaTypes = this.parseProducesMediaTypes();
    }

    private List<String> parseConsumesMediaTypes() {
        String[] consumesMediaTypeArr;
        String[] stringArray = this.method.isAnnotationPresent(Consumes.class) ? this.method.getAnnotation(Consumes.class).value() : (this.handler.getClass().isAnnotationPresent(Consumes.class) ? this.handler.getClass().getAnnotation(Consumes.class).value() : (consumesMediaTypeArr = this.parent == null ? ANY_MEDIA_TYPE : new String[]{}));
        if (this.parent != null && consumesMediaTypeArr.length == 0) {
            HttpResourceModel tmpParent = this.parent;
            while (tmpParent.getConsumesMediaTypes().size() != 0 && tmpParent.getParent() != null) {
                tmpParent = this.parent.getParent();
            }
            consumesMediaTypeArr = tmpParent.getMethod().isAnnotationPresent(Consumes.class) ? tmpParent.getMethod().getAnnotation(Consumes.class).value() : (this.handler.getClass().isAnnotationPresent(Consumes.class) ? this.handler.getClass().getAnnotation(Consumes.class).value() : ANY_MEDIA_TYPE);
        }
        return Arrays.asList(consumesMediaTypeArr);
    }

    private List<String> parseProducesMediaTypes() {
        String[] producesMediaTypeArr;
        String[] stringArray = this.method.isAnnotationPresent(Produces.class) ? this.method.getAnnotation(Produces.class).value() : (this.handler.getClass().isAnnotationPresent(Produces.class) ? this.handler.getClass().getAnnotation(Produces.class).value() : (producesMediaTypeArr = this.parent == null ? ANY_MEDIA_TYPE : new String[]{}));
        if (this.parent != null && producesMediaTypeArr.length == 0) {
            HttpResourceModel tmpParent = this.parent;
            while (tmpParent.getProducesMediaTypes().size() != 0 && tmpParent.getParent() != null) {
                tmpParent = this.parent.getParent();
            }
            producesMediaTypeArr = tmpParent.getMethod().isAnnotationPresent(Produces.class) ? tmpParent.getMethod().getAnnotation(Produces.class).value() : (this.handler.getClass().isAnnotationPresent(Produces.class) ? this.handler.getClass().getAnnotation(Produces.class).value() : ANY_MEDIA_TYPE);
        }
        return Arrays.asList(producesMediaTypeArr);
    }

    public boolean matchConsumeMediaType(String consumesMediaType) {
        return consumesMediaType == null || consumesMediaType.isEmpty() || consumesMediaType.equals("*/*") || this.consumesMediaTypes.contains("*/*") || this.consumesMediaTypes.contains(consumesMediaType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matchProduceMediaType(List<String> producesMediaTypes) {
        if (producesMediaTypes == null) return true;
        if (producesMediaTypes.contains("*/*")) return true;
        if (this.producesMediaTypes.contains("*/*")) return true;
        if (!this.producesMediaTypes.stream().filter(producesMediaTypes::contains).findAny().isPresent()) return false;
        return true;
    }

    public Set<String> getHttpMethod() {
        return this.httpMethods;
    }

    public String getPath() {
        return this.path;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getHttpHandler() {
        return this.handler;
    }

    public void setSubResourceLocator(boolean subResourceLocator) {
        this.isSubResourceLocator = subResourceLocator;
    }

    public boolean isSubResourceLocator() {
        return this.isSubResourceLocator;
    }

    public String toString() {
        return Utils.toString(this, new String[]{"httpMethods", "path", "method", "handler"});
    }

    private Set<String> getHttpMethods(Method method) {
        HashSet<String> httpMethods = new HashSet<String>();
        boolean isSubResourceLocator = true;
        if (method.isAnnotationPresent(GET.class)) {
            httpMethods.add("GET");
            isSubResourceLocator = false;
        }
        if (method.isAnnotationPresent(PUT.class)) {
            httpMethods.add("PUT");
            isSubResourceLocator = false;
        }
        if (method.isAnnotationPresent(POST.class)) {
            httpMethods.add("POST");
            isSubResourceLocator = false;
        }
        if (method.isAnnotationPresent(DELETE.class)) {
            httpMethods.add("DELETE");
            isSubResourceLocator = false;
        }
        if (method.isAnnotationPresent(HEAD.class)) {
            httpMethods.add("HEAD");
            isSubResourceLocator = false;
        }
        if (method.isAnnotationPresent(OPTIONS.class)) {
            httpMethods.add("OPTIONS");
            isSubResourceLocator = false;
        }
        if (isSubResourceLocator) {
            httpMethods.add("GET");
            httpMethods.add("POST");
            httpMethods.add("PUT");
            httpMethods.add("DELETE");
            httpMethods.add("HEAD");
            httpMethods.add("OPTIONS");
        }
        return Collections.unmodifiableSet(httpMethods);
    }

    private List<ParameterInfo<?>> makeParamInfoList(Method method) {
        ArrayList paramInfoList = new ArrayList();
        Type[] paramTypes = method.getGenericParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < paramAnnotations.length; ++i) {
            Annotation[] annotations = paramAnnotations[i];
            if (Utils.getIntersection(SUPPORTED_PARAM_ANNOTATIONS, Collections.unmodifiableSet(new HashSet<Annotation>(Arrays.asList(annotations)))) > 1) {
                throw new IllegalArgumentException(String.format("Must have exactly one annotation from %s for parameter %d in method %s", SUPPORTED_PARAM_ANNOTATIONS, i, method));
            }
            Annotation annotation = null;
            Type parameterType = paramTypes[i];
            Function<Object, Object> converter = null;
            String defaultVal = null;
            for (Annotation annotation0 : annotations) {
                annotation = annotation0;
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (PathParam.class.isAssignableFrom(annotationType)) {
                    converter = ParamConvertUtils.createPathParamConverter(parameterType);
                    continue;
                }
                if (QueryParam.class.isAssignableFrom(annotationType)) {
                    converter = ParamConvertUtils.createQueryParamConverter(parameterType);
                    continue;
                }
                if (FormParam.class.isAssignableFrom(annotationType)) {
                    converter = ParamConvertUtils.createFormParamConverter(parameterType);
                    continue;
                }
                if (FormDataParam.class.isAssignableFrom(annotationType)) {
                    converter = ParamConvertUtils.createFormDataParamConverter(parameterType);
                    continue;
                }
                if (HeaderParam.class.isAssignableFrom(annotationType)) {
                    converter = ParamConvertUtils.createHeaderParamConverter(parameterType);
                    continue;
                }
                if (CookieParam.class.isAssignableFrom(annotationType)) {
                    converter = ParamConvertUtils.createCookieParamConverter(parameterType);
                    continue;
                }
                if (!DefaultValue.class.isAssignableFrom(annotationType)) continue;
                defaultVal = ((DefaultValue)annotation).value();
            }
            ParameterInfo parameterInfo = ParameterInfo.create(parameterType, annotation, defaultVal, converter);
            paramInfoList.add(parameterInfo);
        }
        return Collections.unmodifiableList(paramInfoList);
    }

    public boolean isStreamingReqSupported() {
        if (this.isStreamingReqSupported == 1) {
            return true;
        }
        if (this.isStreamingReqSupported == 2) {
            return false;
        }
        if (this.paramInfoList.stream().filter(parameterInfo -> parameterInfo.getParameterType().equals(HttpStreamer.class)).findAny().isPresent()) {
            this.isStreamingReqSupported = 1;
            return true;
        }
        this.isStreamingReqSupported = 2;
        return false;
    }

    public List<ParameterInfo<?>> getParamInfoList() {
        return this.paramInfoList;
    }

    public List<String> getConsumesMediaTypes() {
        return this.consumesMediaTypes;
    }

    public List<String> getProducesMediaTypes() {
        return this.producesMediaTypes;
    }

    static {
        HashSet<Class<CookieParam>> supportedAnnotation = new HashSet<Class<CookieParam>>();
        supportedAnnotation.add(PathParam.class);
        supportedAnnotation.add(QueryParam.class);
        supportedAnnotation.add(HeaderParam.class);
        supportedAnnotation.add(Context.class);
        supportedAnnotation.add(FormParam.class);
        supportedAnnotation.add(FormDataParam.class);
        supportedAnnotation.add(CookieParam.class);
        SUPPORTED_PARAM_ANNOTATIONS = Collections.unmodifiableSet(supportedAnnotation);
        ANY_MEDIA_TYPE = new String[]{"*/*"};
    }

    public static final class ParameterInfo<T> {
        private final Annotation annotation;
        private final Function<T, Object> converter;
        private final Type parameterType;
        private final String defaultVal;

        private ParameterInfo(Type parameterType, Annotation annotation, String defaultVal, @Nullable Function<T, Object> converter) {
            this.parameterType = parameterType;
            this.annotation = annotation;
            this.defaultVal = defaultVal;
            this.converter = converter;
        }

        static <V> ParameterInfo<V> create(Type parameterType, Annotation annotation, String defaultVal, @Nullable Function<V, Object> converter) {
            return new ParameterInfo<V>(parameterType, annotation, defaultVal, converter);
        }

        <V extends Annotation> V getAnnotation() {
            return (V)this.annotation;
        }

        public Type getParameterType() {
            return this.parameterType;
        }

        public String getDefaultVal() {
            return this.defaultVal;
        }

        Object convert(T input) {
            return this.converter == null ? null : this.converter.apply(input);
        }

        public Function<T, Object> getConverter() {
            return this.converter;
        }
    }
}

