/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.securevault.repository;

import java.util.ArrayList;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.securevault.MasterKey;
import org.wso2.carbon.kernel.securevault.MasterKeyReader;
import org.wso2.carbon.kernel.securevault.SecretRepository;
import org.wso2.carbon.kernel.securevault.cipher.JKSBasedCipherProvider;
import org.wso2.carbon.kernel.securevault.config.model.SecretRepositoryConfiguration;
import org.wso2.carbon.kernel.securevault.exception.SecureVaultException;
import org.wso2.carbon.kernel.securevault.repository.AbstractSecretRepository;

@Component(name="org.wso2.carbon.kernel.securevault.repository.DefaultSecretRepository", immediate=true, property={"capabilityName=org.wso2.carbon.kernel.securevault.SecretRepository"}, service={SecretRepository.class})
public class DefaultSecretRepository
extends AbstractSecretRepository {
    private static Logger logger = LoggerFactory.getLogger(AbstractSecretRepository.class);
    private JKSBasedCipherProvider jksBasedCipherProvider;

    @Activate
    public void activate() {
        logger.debug("Activating DefaultSecretRepository");
    }

    @Deactivate
    public void deactivate() {
        logger.debug("Deactivating DefaultSecretRepository");
    }

    @Override
    public void init(SecretRepositoryConfiguration secretRepositoryConfiguration, MasterKeyReader masterKeyReader) throws SecureVaultException {
        ArrayList<MasterKey> masterKeys = new ArrayList<MasterKey>();
        masterKeys.add(new MasterKey("keyStorePassword"));
        masterKeys.add(new MasterKey("privateKeyPassword"));
        masterKeyReader.readMasterKeys(masterKeys);
        this.jksBasedCipherProvider = new JKSBasedCipherProvider();
        this.jksBasedCipherProvider.init(secretRepositoryConfiguration, masterKeys);
        logger.debug("DefaultSecretRepository initialized with '{}'", (Object)JKSBasedCipherProvider.class.getName());
    }

    @Override
    public byte[] encrypt(byte[] plainText) throws SecureVaultException {
        return this.jksBasedCipherProvider.encrypt(plainText);
    }

    @Override
    public byte[] decrypt(byte[] cipherText) throws SecureVaultException {
        return this.jksBasedCipherProvider.decrypt(cipherText);
    }
}

