/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.common.ssl;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSLConfig.class);
    private static final String separator = ",";
    private File keyStore;
    private String keyStorePass;
    private String certPass;
    private File trustStore;
    private String trustStorePass;
    private String[] cipherSuites;
    private String[] enableProtocols;
    private boolean enableSessionCreation;
    private boolean needClientAuth;
    private boolean wantClientAuth;
    private String[] serverNames;
    private String[] sniMatchers;
    private boolean clientMode;

    public SSLConfig(File keyStore, String keyStorePass) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Using key store" + keyStore);
        }
        this.keyStore = keyStore;
        this.keyStorePass = keyStorePass;
    }

    public String getCertPass() {
        return this.certPass;
    }

    public SSLConfig setCertPass(String certPass) {
        this.certPass = certPass;
        return this;
    }

    public File getTrustStore() {
        return this.trustStore;
    }

    public SSLConfig setTrustStore(File trustStore) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Using trust store" + trustStore);
        }
        this.trustStore = trustStore;
        return this;
    }

    public String getTrustStorePass() {
        return this.trustStorePass;
    }

    public SSLConfig setTrustStorePass(String trustStorePass) {
        this.trustStorePass = trustStorePass;
        return this;
    }

    public File getKeyStore() {
        return this.keyStore;
    }

    public String getKeyStorePass() {
        return this.keyStorePass;
    }

    public String[] getSniMatchers() {
        return this.sniMatchers == null ? null : (String[])this.sniMatchers.clone();
    }

    public void setSniMatchers(String sniMatchers) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Using sniMatchers" + sniMatchers);
        }
        this.sniMatchers = sniMatchers.split(separator);
    }

    public String[] getServerNames() {
        return this.serverNames == null ? null : (String[])this.serverNames.clone();
    }

    public void setServerNames(String serverNames) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Using serverNames" + serverNames);
        }
        this.serverNames = serverNames.replaceAll("\\s+", "").split(separator);
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Set WantClientAuth" + wantClientAuth);
        }
        this.wantClientAuth = wantClientAuth;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Set NeedClientAuth" + needClientAuth);
        }
        this.needClientAuth = needClientAuth;
    }

    public boolean isEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public void setEnableSessionCreation(boolean enableSessionCreation) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Enable Session Creation" + enableSessionCreation);
        }
        this.enableSessionCreation = enableSessionCreation;
    }

    public String[] getEnableProtocols() {
        return this.enableProtocols == null ? null : (String[])this.enableProtocols.clone();
    }

    public void setEnableProtocols(String enableProtocols) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Set enable protocols" + enableProtocols);
        }
        this.enableProtocols = enableProtocols.replaceAll("\\s+", "").split(separator);
    }

    public String[] getCipherSuites() {
        return this.cipherSuites == null ? null : (String[])this.cipherSuites.clone();
    }

    public void setCipherSuites(String cipherSuites) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Set supported cipherSuites" + cipherSuites);
        }
        this.cipherSuites = cipherSuites.replaceAll("\\s+", "").split(separator);
    }

    public boolean isClientMode() {
        return this.clientMode;
    }

    public void setClientMode(boolean clientMode) {
        this.clientMode = clientMode;
    }
}

