/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.listener.http2;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.config.ListenerConfiguration;
import org.wso2.transport.http.netty.config.RequestSizeValidationConfiguration;
import org.wso2.transport.http.netty.contractimpl.HttpWsServerConnectorFuture;
import org.wso2.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.transport.http.netty.listener.CustomHttpObjectAggregator;
import org.wso2.transport.http.netty.listener.CustomHttpRequestDecoder;
import org.wso2.transport.http.netty.listener.SourceHandler;
import org.wso2.transport.http.netty.listener.http2.HTTP2SourceHandlerBuilder;
import org.wso2.transport.http.netty.sender.channel.pool.ConnectionManager;

public class HTTPProtocolNegotiationHandler
extends ApplicationProtocolNegotiationHandler {
    private static final Logger log = LoggerFactory.getLogger(HTTPProtocolNegotiationHandler.class);
    protected ConnectionManager connectionManager;
    protected ListenerConfiguration listenerConfiguration;
    protected RequestSizeValidationConfiguration requestSizeValidationConfig;

    public HTTPProtocolNegotiationHandler(ConnectionManager connectionManager, ListenerConfiguration listenerConfiguration) {
        super("http/1.1");
        this.listenerConfiguration = listenerConfiguration;
        this.connectionManager = connectionManager;
        this.requestSizeValidationConfig = listenerConfiguration.getRequestSizeValidationConfig();
    }

    @Override
    protected void configurePipeline(ChannelHandlerContext ctx, String protocol) throws Exception {
        ChannelPipeline p = ctx.pipeline();
        if ("h2".equals(protocol)) {
            ctx.pipeline().addLast("http2-handler", (ChannelHandler)new HTTP2SourceHandlerBuilder(this.connectionManager, this.listenerConfiguration).build());
            return;
        }
        if ("http/1.1".equals(protocol)) {
            p.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
            if (this.requestSizeValidationConfig.isHeaderSizeValidation()) {
                p.addLast("decoder", (ChannelHandler)new CustomHttpRequestDecoder(this.requestSizeValidationConfig));
            } else {
                p.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
            }
            if (this.requestSizeValidationConfig.isRequestSizeValidation()) {
                p.addLast("custom-aggregator", (ChannelHandler)new CustomHttpObjectAggregator(this.requestSizeValidationConfig));
            }
            p.addLast("compressor", (ChannelHandler)new HttpContentCompressor());
            p.addLast("chunkWriter", (ChannelHandler)new ChunkedWriteHandler());
            try {
                p.addLast("handler", (ChannelHandler)new SourceHandler(new HttpWsServerConnectorFuture(null), null));
            }
            catch (Exception e) {
                log.error("Cannot Create SourceHandler ", e);
            }
            return;
        }
        throw new IllegalStateException("unknown protocol: " + protocol);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (ctx != null && ctx.channel().isActive()) {
            ctx.writeAndFlush(Unpooled.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
        }
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceConnectionInitiation(Integer.toString(ctx.hashCode()));
        }
    }
}

