/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.listener;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.Constants;
import org.wso2.transport.http.netty.contractimpl.listener.HttpServerChannelInitializer;

public class SslHandshakeCompletionHandlerForServer
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(SslHandshakeCompletionHandlerForServer.class);
    private HttpServerChannelInitializer httpServerChannelInitializer;
    private ChannelPipeline serverPipeline;
    private SSLEngine sslEngine;

    SslHandshakeCompletionHandlerForServer(HttpServerChannelInitializer httpServerChannelInitializer, ChannelPipeline serverPipeline, SSLEngine sslEngine) {
        this.httpServerChannelInitializer = httpServerChannelInitializer;
        this.serverPipeline = serverPipeline;
        this.sslEngine = sslEngine;
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SslHandshakeCompletionEvent) {
            SslHandshakeCompletionEvent event = (SslHandshakeCompletionEvent)evt;
            if (event.isSuccess()) {
                if (this.sslEngine.getWantClientAuth() || this.sslEngine.getNeedClientAuth()) {
                    try {
                        Certificate[] certs = this.sslEngine.getSession().getPeerCertificates();
                        X509Certificate endUserCert = (X509Certificate)certs[0];
                        endUserCert.checkValidity(new Date());
                        ctx.channel().attr(Constants.MUTUAL_SSL_RESULT_ATTRIBUTE).set("passed");
                    }
                    catch (SSLPeerUnverifiedException e) {
                        ctx.channel().attr(Constants.MUTUAL_SSL_RESULT_ATTRIBUTE).set("failed");
                    }
                }
                this.httpServerChannelInitializer.configureHttpPipeline(this.serverPipeline, "http");
                ctx.pipeline().remove(this);
                ctx.fireChannelActive();
            } else {
                ctx.close();
            }
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.error("Error while SSL handshake: " + cause.getMessage());
    }
}

