/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender.states.http2;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.exceptions.EndpointTimeOutException;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2MessageStateContext;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2StateUtil;
import org.wso2.transport.http.netty.contractimpl.common.states.StateUtil;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2ClientChannel;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2TargetHandler;
import org.wso2.transport.http.netty.contractimpl.sender.http2.OutboundMsgHolder;
import org.wso2.transport.http.netty.contractimpl.sender.states.http2.EntityBodyReceived;
import org.wso2.transport.http.netty.contractimpl.sender.states.http2.ReceivingEntityBody;
import org.wso2.transport.http.netty.contractimpl.sender.states.http2.SenderState;
import org.wso2.transport.http.netty.contractimpl.sender.states.http2.SendingEntityBody;
import org.wso2.transport.http.netty.message.Http2DataFrame;
import org.wso2.transport.http.netty.message.Http2HeadersFrame;
import org.wso2.transport.http.netty.message.Http2InboundContentListener;
import org.wso2.transport.http.netty.message.Http2PushPromise;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;
import org.wso2.transport.http.netty.message.HttpCarbonResponse;
import org.wso2.transport.http.netty.message.Listener;
import org.wso2.transport.http.netty.message.PooledDataStreamerFactory;

public class ReceivingHeaders
implements SenderState {
    private static final Logger LOG = LoggerFactory.getLogger(ReceivingHeaders.class);
    private final Http2TargetHandler http2TargetHandler;
    private final Http2ClientChannel http2ClientChannel;
    private final Http2TargetHandler.Http2RequestWriter http2RequestWriter;

    public ReceivingHeaders(Http2TargetHandler http2TargetHandler, Http2TargetHandler.Http2RequestWriter http2RequestWriter) {
        this.http2TargetHandler = http2TargetHandler;
        this.http2RequestWriter = http2RequestWriter;
        this.http2ClientChannel = http2TargetHandler.getHttp2ClientChannel();
    }

    @Override
    public void writeOutboundRequestHeaders(ChannelHandlerContext ctx, HttpContent httpContent) {
        LOG.warn("writeOutboundRequestHeaders is not a dependant action of this state");
    }

    @Override
    public void writeOutboundRequestBody(ChannelHandlerContext ctx, HttpContent httpContent, Http2MessageStateContext http2MessageStateContext) throws Http2Exception {
        if (this.http2RequestWriter != null) {
            http2MessageStateContext.setSenderState(new SendingEntityBody(this.http2TargetHandler, this.http2RequestWriter));
            http2MessageStateContext.getSenderState().writeOutboundRequestBody(ctx, httpContent, http2MessageStateContext);
        } else {
            Http2StateUtil.releaseContent(httpContent);
        }
    }

    @Override
    public void readInboundResponseHeaders(ChannelHandlerContext ctx, Http2HeadersFrame http2HeadersFrame, OutboundMsgHolder outboundMsgHolder, boolean serverPush, Http2MessageStateContext http2MessageStateContext) {
        this.onHeadersRead(ctx, http2HeadersFrame, outboundMsgHolder, serverPush, http2MessageStateContext);
    }

    @Override
    public void readInboundResponseBody(ChannelHandlerContext ctx, Http2DataFrame http2DataFrame, OutboundMsgHolder outboundMsgHolder, boolean serverPush, Http2MessageStateContext http2MessageStateContext) {
        LOG.warn("readInboundResponseBody is not a dependant action of this state");
    }

    @Override
    public void readInboundPromise(ChannelHandlerContext ctx, Http2PushPromise http2PushPromise, OutboundMsgHolder outboundMsgHolder) {
        LOG.warn("readInboundPromise is not a dependant action of this state");
    }

    @Override
    public void handleStreamTimeout(OutboundMsgHolder outboundMsgHolder, boolean serverPush, ChannelHandlerContext ctx, int streamId) {
        if (!serverPush) {
            outboundMsgHolder.getResponseFuture().notifyHttpListener(new EndpointTimeOutException("Idle timeout triggered while reading inbound response headers", HttpResponseStatus.GATEWAY_TIMEOUT.code()));
        }
    }

    @Override
    public void handleConnectionClose(OutboundMsgHolder outboundMsgHolder) {
        StateUtil.handleIncompleteInboundMessage(outboundMsgHolder.getResponse(), "Remote host closed the connection while reading inbound response headers");
    }

    private void onHeadersRead(ChannelHandlerContext ctx, Http2HeadersFrame http2HeadersFrame, OutboundMsgHolder outboundMsgHolder, boolean serverPush, Http2MessageStateContext http2MessageStateContext) {
        int streamId = http2HeadersFrame.getStreamId();
        Http2Headers http2Headers = http2HeadersFrame.getHeaders();
        boolean endOfStream = http2HeadersFrame.isEndOfStream();
        if (serverPush) {
            this.onServerPushHeadersRead(ctx, outboundMsgHolder, streamId, endOfStream, http2Headers, http2MessageStateContext);
        } else {
            this.onResponseHeadersRead(ctx, outboundMsgHolder, streamId, endOfStream, http2Headers, http2MessageStateContext);
        }
    }

    private void onServerPushHeadersRead(ChannelHandlerContext ctx, OutboundMsgHolder outboundMsgHolder, int streamId, boolean endOfStream, Http2Headers http2Headers, Http2MessageStateContext http2MessageStateContext) {
        if (endOfStream) {
            HttpCarbonResponse responseMessage = outboundMsgHolder.getPushResponse(streamId);
            if (responseMessage != null) {
                this.onTrailersRead(streamId, http2Headers, outboundMsgHolder, responseMessage);
            } else if (http2Headers.contains(":status")) {
                responseMessage = this.setupResponseCarbonMessage(ctx, streamId, http2Headers, outboundMsgHolder);
                this.checkForTrailerHeaders(streamId, http2Headers, outboundMsgHolder, responseMessage);
                outboundMsgHolder.addPushResponse(streamId, responseMessage);
            }
            this.http2ClientChannel.removePromisedMessage(streamId);
            http2MessageStateContext.setSenderState(new EntityBodyReceived(this.http2TargetHandler, this.http2RequestWriter));
        } else {
            HttpCarbonResponse responseMessage = this.setupResponseCarbonMessage(ctx, streamId, http2Headers, outboundMsgHolder);
            outboundMsgHolder.addPushResponse(streamId, responseMessage);
            http2MessageStateContext.setSenderState(new ReceivingEntityBody(this.http2TargetHandler, this.http2RequestWriter));
        }
    }

    private void onResponseHeadersRead(ChannelHandlerContext ctx, OutboundMsgHolder outboundMsgHolder, int streamId, boolean endOfStream, Http2Headers http2Headers, Http2MessageStateContext http2MessageStateContext) {
        if (endOfStream) {
            HttpCarbonResponse responseMessage = outboundMsgHolder.getResponse();
            if (responseMessage != null) {
                this.onTrailersRead(streamId, http2Headers, outboundMsgHolder, responseMessage);
            } else if (http2Headers.contains(":status")) {
                responseMessage = this.setupResponseCarbonMessage(ctx, streamId, http2Headers, outboundMsgHolder);
                this.checkForTrailerHeaders(streamId, http2Headers, outboundMsgHolder, responseMessage);
                outboundMsgHolder.setResponse(responseMessage);
            }
            this.http2ClientChannel.removeInFlightMessage(streamId);
            http2MessageStateContext.setSenderState(new EntityBodyReceived(this.http2TargetHandler, this.http2RequestWriter));
        } else {
            HttpCarbonResponse responseMessage = this.setupResponseCarbonMessage(ctx, streamId, http2Headers, outboundMsgHolder);
            outboundMsgHolder.setResponse(responseMessage);
            http2MessageStateContext.setSenderState(new ReceivingEntityBody(this.http2TargetHandler, this.http2RequestWriter));
        }
    }

    private void checkForTrailerHeaders(int streamId, Http2Headers http2Headers, OutboundMsgHolder outboundMsgHolder, HttpCarbonResponse responseMessage) {
        String[] trailerKeys;
        if (!http2Headers.contains(HttpHeaderNames.TRAILER)) {
            this.completeResponseMessage(responseMessage, new DefaultLastHttpContent());
            return;
        }
        String trailerHeader = ((CharSequence)http2Headers.get(HttpHeaderNames.TRAILER)).toString();
        DefaultHttp2Headers newHttp2Headers = new DefaultHttp2Headers();
        for (String key : trailerKeys = trailerHeader.split(",")) {
            String headerKey = key.toLowerCase(Locale.getDefault()).trim();
            CharSequence headerValue = (CharSequence)http2Headers.get(headerKey);
            if (headerValue == null) continue;
            newHttp2Headers.add(headerKey, headerValue);
        }
        if (newHttp2Headers.isEmpty()) {
            this.completeResponseMessage(responseMessage, new DefaultLastHttpContent());
        } else {
            this.onTrailersRead(streamId, newHttp2Headers, outboundMsgHolder, responseMessage);
        }
    }

    private void onTrailersRead(int streamId, Http2Headers headers, OutboundMsgHolder outboundMsgHolder, HttpCarbonMessage responseMessage) {
        HttpVersion version = new HttpVersion("HTTP/2.0", true);
        DefaultLastHttpContent lastHttpContent = new DefaultLastHttpContent();
        HttpHeaders trailers = lastHttpContent.trailingHeaders();
        try {
            HttpConversionUtil.addHttp2ToHttpHeaders(streamId, headers, trailers, version, true, false);
            StateUtil.setInboundTrailersToNewMessage(trailers, responseMessage);
        }
        catch (Http2Exception e) {
            outboundMsgHolder.getResponseFuture().notifyHttpListener(new Exception("Error while setting http headers", e));
        }
        this.completeResponseMessage(responseMessage, lastHttpContent);
    }

    private void completeResponseMessage(HttpCarbonMessage responseMessage, LastHttpContent lastHttpContent) {
        responseMessage.addHttpContent(lastHttpContent);
        responseMessage.setLastHttpContentArrived();
    }

    private HttpCarbonResponse setupResponseCarbonMessage(ChannelHandlerContext ctx, int streamId, Http2Headers http2Headers, OutboundMsgHolder outboundMsgHolder) {
        HttpResponseStatus responseStatus;
        CharSequence status = http2Headers.status();
        try {
            responseStatus = HttpConversionUtil.parseStatus(status);
        }
        catch (Http2Exception e) {
            responseStatus = HttpResponseStatus.BAD_GATEWAY;
        }
        HttpVersion version = new HttpVersion("HTTP/2.0", true);
        DefaultHttpResponse httpResponse = new DefaultHttpResponse(version, responseStatus);
        try {
            HttpConversionUtil.addHttp2ToHttpHeaders(streamId, http2Headers, httpResponse.headers(), version, false, false);
            CharSequence trailerHeaderValue = (CharSequence)http2Headers.get(HttpHeaderNames.TRAILER.toString());
            if (trailerHeaderValue != null) {
                httpResponse.headers().add(HttpHeaderNames.TRAILER.toString(), (Object)trailerHeaderValue.toString());
            }
        }
        catch (Http2Exception e) {
            outboundMsgHolder.getResponseFuture().notifyHttpListener(new Exception("Error while setting http headers", e));
        }
        HttpCarbonResponse responseCarbonMsg = new HttpCarbonResponse(httpResponse, (Listener)new Http2InboundContentListener(streamId, ctx, this.http2TargetHandler.getConnection(), "INBOUND_RESPONSE"));
        responseCarbonMsg.setProperty("POOLED_BYTE_BUFFER_FACTORY", new PooledDataStreamerFactory(ctx.alloc()));
        responseCarbonMsg.setProperty("DIRECTION", "DIRECTION_RESPONSE");
        responseCarbonMsg.setHttpStatusCode(httpResponse.status().code());
        responseCarbonMsg.setProperty("executor.workerpool", outboundMsgHolder.getRequest().getProperty("executor.workerpool"));
        return responseCarbonMsg;
    }
}

