/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.sender.channel.pool;

import com.lmax.disruptor.RingBuffer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.transport.http.netty.common.HttpRoute;
import org.wso2.carbon.transport.http.netty.config.SenderConfiguration;
import org.wso2.carbon.transport.http.netty.listener.SourceHandler;
import org.wso2.carbon.transport.http.netty.sender.ClientRequestWorker;
import org.wso2.carbon.transport.http.netty.sender.channel.TargetChannel;
import org.wso2.carbon.transport.http.netty.sender.channel.pool.PoolConfiguration;
import org.wso2.carbon.transport.http.netty.sender.channel.pool.PoolableTargetChannelFactory;

public class ConnectionManager {
    private static final Logger log = LoggerFactory.getLogger(ConnectionManager.class);
    private static volatile ConnectionManager connectionManager;
    private PoolConfiguration poolConfiguration;
    private int poolCount;
    private final List<Map<String, GenericObjectPool>> poolList;
    private final Map<String, GenericObjectPool> localConnectionMap;
    private PoolManagementPolicy poolManagementPolicy;
    private AtomicInteger index = new AtomicInteger(1);
    private ExecutorService executorService;

    private ConnectionManager(PoolConfiguration poolConfiguration) {
        this.poolConfiguration = poolConfiguration;
        this.poolCount = poolConfiguration.getNumberOfPools();
        this.executorService = Executors.newFixedThreadPool(poolConfiguration.getExecutorServiceThreads());
        this.localConnectionMap = new ConcurrentHashMap<String, GenericObjectPool>();
        this.poolManagementPolicy = poolConfiguration.getNumberOfPools() == 0 ? PoolManagementPolicy.PER_SERVER_CHANNEL_ENDPOINT_CONNECTION_CACHING : PoolManagementPolicy.GLOBAL_ENDPOINT_CONNECTION_CACHING;
        this.poolList = new ArrayList<Map<String, GenericObjectPool>>();
        for (int i = 0; i < this.poolCount; ++i) {
            ConcurrentHashMap map = new ConcurrentHashMap();
            this.poolList.add(map);
        }
    }

    private GenericObjectPool createPoolForRoute(HttpRoute httpRoute, EventLoopGroup eventLoopGroup, Class eventLoopClass, SenderConfiguration senderConfiguration) {
        GenericObjectPool.Config config = new GenericObjectPool.Config();
        config.maxActive = this.poolConfiguration.getMaxActivePerPool();
        config.maxIdle = this.poolConfiguration.getMaxIdlePerPool();
        config.minIdle = this.poolConfiguration.getMinIdlePerPool();
        config.testOnBorrow = this.poolConfiguration.isTestOnBorrow();
        config.testWhileIdle = this.poolConfiguration.isTestWhileIdle();
        config.timeBetweenEvictionRunsMillis = this.poolConfiguration.getTimeBetweenEvictionRuns();
        config.minEvictableIdleTimeMillis = this.poolConfiguration.getMinEvictableIdleTime();
        config.whenExhaustedAction = this.poolConfiguration.getExhaustedAction();
        return new GenericObjectPool((PoolableObjectFactory)new PoolableTargetChannelFactory(httpRoute, eventLoopGroup, eventLoopClass, senderConfiguration), config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConnectionManager getInstance(Map<String, String> parameters) {
        if (connectionManager != null) return connectionManager;
        Class<ConnectionManager> clazz = ConnectionManager.class;
        synchronized (ConnectionManager.class) {
            if (connectionManager != null) return connectionManager;
            PoolConfiguration poolConfiguration = PoolConfiguration.getInstance();
            if (poolConfiguration == null) {
                PoolConfiguration.createPoolConfiguration(parameters);
                poolConfiguration = PoolConfiguration.getInstance();
            }
            connectionManager = new ConnectionManager(poolConfiguration);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return connectionManager;
        }
    }

    public TargetChannel getTargetChannel(HttpRoute httpRoute, SourceHandler sourceHandler, SenderConfiguration senderConfiguration, HttpRequest httpRequest, CarbonMessage carbonMessage, CarbonCallback carbonCallback, RingBuffer ringBuffer) throws Exception {
        TargetChannel targetChannel = null;
        Class cl = null;
        EventLoopGroup group = null;
        if (sourceHandler != null) {
            ChannelHandlerContext ctx = sourceHandler.getInboundChannelContext();
            group = ctx.channel().eventLoop();
            cl = ctx.channel().getClass();
        } else {
            cl = NioSocketChannel.class;
            group = new NioEventLoopGroup(Integer.parseInt(senderConfiguration.getSenderWorkerThreads()));
            this.poolManagementPolicy = PoolManagementPolicy.DEFAULT_POOLING;
        }
        if (this.poolManagementPolicy == PoolManagementPolicy.GLOBAL_ENDPOINT_CONNECTION_CACHING) {
            Map<String, GenericObjectPool> objectPoolMap = sourceHandler.getTargetChannelPool();
            GenericObjectPool pool = objectPoolMap.get(httpRoute.toString());
            if (pool == null) {
                pool = this.createPoolForRoute(httpRoute, group, cl, senderConfiguration);
                objectPoolMap.put(httpRoute.toString(), pool);
            }
            try {
                this.executorService.execute(new ClientRequestWorker(httpRoute, sourceHandler, senderConfiguration, httpRequest, carbonMessage, carbonCallback, PoolManagementPolicy.GLOBAL_ENDPOINT_CONNECTION_CACHING, pool, this, ringBuffer, group, cl));
            }
            catch (Exception e) {
                String msg = "Cannot borrow free channel from pool ";
                log.error(msg, e);
                throw new Exception(msg, e);
            }
        } else if (this.poolManagementPolicy == PoolManagementPolicy.PER_SERVER_CHANNEL_ENDPOINT_CONNECTION_CACHING) {
            if (!this.isRouteExists(httpRoute, sourceHandler)) {
                this.executorService.execute(new ClientRequestWorker(httpRoute, sourceHandler, senderConfiguration, httpRequest, carbonMessage, carbonCallback, PoolManagementPolicy.PER_SERVER_CHANNEL_ENDPOINT_CONNECTION_CACHING, null, this, ringBuffer, group, cl));
            } else {
                targetChannel = sourceHandler.getChannel(httpRoute);
                Channel tempc = targetChannel.getChannel();
                if (!tempc.isActive()) {
                    this.executorService.execute(new ClientRequestWorker(httpRoute, sourceHandler, senderConfiguration, httpRequest, carbonMessage, carbonCallback, PoolManagementPolicy.PER_SERVER_CHANNEL_ENDPOINT_CONNECTION_CACHING, null, this, ringBuffer, group, cl));
                    targetChannel = null;
                    sourceHandler.removeChannelFuture(httpRoute);
                }
            }
        } else if (this.poolManagementPolicy == PoolManagementPolicy.DEFAULT_POOLING) {
            GenericObjectPool pool = this.localConnectionMap.get(httpRoute.toString());
            if (pool == null) {
                pool = this.createPoolForRoute(httpRoute, group, cl, senderConfiguration);
                this.localConnectionMap.put(httpRoute.toString(), pool);
            }
            this.executorService.execute(new ClientRequestWorker(httpRoute, sourceHandler, senderConfiguration, httpRequest, carbonMessage, carbonCallback, PoolManagementPolicy.DEFAULT_POOLING, pool, this, ringBuffer, group, cl));
        }
        if (targetChannel != null) {
            targetChannel.setHttpRoute(httpRoute);
            if (sourceHandler != null) {
                targetChannel.setCorrelatedSource(sourceHandler);
            }
        }
        return targetChannel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void returnChannel(TargetChannel targetChannel) throws Exception {
        if (this.poolManagementPolicy == PoolManagementPolicy.GLOBAL_ENDPOINT_CONNECTION_CACHING) {
            Map<String, GenericObjectPool> objectPoolMap = targetChannel.getCorrelatedSource().getTargetChannelPool();
            GenericObjectPool pool = objectPoolMap.get(targetChannel.getHttpRoute().toString());
            try {
                if (!targetChannel.getChannel().isActive()) return;
                pool.returnObject(targetChannel);
                return;
            }
            catch (Exception e) {
                String msg = "Cannot return channel to pool";
                log.error(msg, e);
                throw new Exception(msg, e);
            }
        }
        if (this.poolManagementPolicy != PoolManagementPolicy.DEFAULT_POOLING) return;
        HttpRoute httpRoute = targetChannel.getHttpRoute();
        GenericObjectPool pool = this.localConnectionMap.get(httpRoute.toString());
        try {
            if (!targetChannel.getChannel().isActive()) return;
            pool.returnObject(targetChannel);
            return;
        }
        catch (Exception e) {
            String msg = "Cannot return channel to pool";
            log.error(msg, e);
            throw new Exception(msg, e);
        }
    }

    private boolean isRouteExists(HttpRoute httpRoute, SourceHandler srcHandler) {
        return srcHandler.getChannel(httpRoute) != null;
    }

    public Map<String, GenericObjectPool> getTargetChannelPool() {
        if (this.poolManagementPolicy == PoolManagementPolicy.GLOBAL_ENDPOINT_CONNECTION_CACHING) {
            int ind = this.index.getAndIncrement() % this.poolCount;
            return this.poolList.get(ind);
        }
        return null;
    }

    public void notifyChannelInactive() {
        if (this.poolManagementPolicy == PoolManagementPolicy.GLOBAL_ENDPOINT_CONNECTION_CACHING) {
            this.index.getAndDecrement();
        }
    }

    public static enum PoolManagementPolicy {
        PER_SERVER_CHANNEL_ENDPOINT_CONNECTION_CACHING,
        GLOBAL_ENDPOINT_CONNECTION_CACHING,
        DEFAULT_POOLING;

    }
}

