/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.deployment.engine.internal;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.deployment.engine.Deployer;
import org.wso2.carbon.deployment.engine.DeploymentService;
import org.wso2.carbon.deployment.engine.LifecycleListener;
import org.wso2.carbon.deployment.engine.exception.DeployerRegistrationException;
import org.wso2.carbon.deployment.engine.exception.DeploymentEngineException;
import org.wso2.carbon.deployment.engine.internal.CarbonDeploymentService;
import org.wso2.carbon.deployment.engine.internal.DataHolder;
import org.wso2.carbon.deployment.engine.internal.DeploymentEngine;
import org.wso2.carbon.deployment.engine.internal.OSGiServiceHolder;
import org.wso2.carbon.kernel.CarbonRuntime;
import org.wso2.carbon.kernel.startupresolver.RequiredCapabilityListener;

@Component(name="org.wso2.carbon.deployment.engine.internal.DeploymentEngineListenerComponent", immediate=true, property={"componentName=carbon-deployment-service"})
public class DeploymentEngineListenerComponent
implements RequiredCapabilityListener {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentEngineListenerComponent.class);
    private DeploymentEngine deploymentEngine = new DeploymentEngine();
    private ServiceRegistration serviceRegistration;

    @Activate
    public void start(BundleContext bundleContext) throws Exception {
        DataHolder.getInstance().setBundleContext(bundleContext);
    }

    @Deactivate
    public void stop() throws Exception {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    @Reference(name="carbon.deployer.service", service=Deployer.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unregisterDeployer")
    protected void registerDeployer(Deployer deployer) {
        try {
            this.deploymentEngine.registerDeployer(deployer);
        }
        catch (DeployerRegistrationException e) {
            logger.error("Error while adding deployer to the deployment engine", e);
        }
    }

    protected void unregisterDeployer(Deployer deployer) {
        try {
            this.deploymentEngine.unregisterDeployer(deployer);
        }
        catch (DeploymentEngineException e) {
            logger.error("Error while removing deployer from deployment engine", e);
        }
    }

    @Reference(name="carbon.deployment.listener.service", service=LifecycleListener.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unregisterDeploymentListener")
    protected void registerDeploymentListener(LifecycleListener listener) {
        logger.debug("Received LifecycleListener {} ", (Object)listener.getClass().getName());
        this.deploymentEngine.registerDeploymentLifecycleListener(listener);
    }

    protected void unregisterDeploymentListener(LifecycleListener listener) {
        this.deploymentEngine.unregisterDeploymentLifecycleListener(listener);
    }

    @Reference(name="carbon.runtime.service", service=CarbonRuntime.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unregisterCarbonRuntime")
    protected void registerCarbonRuntime(CarbonRuntime carbonRuntime) {
        DataHolder.getInstance().setCarbonRuntime(carbonRuntime);
    }

    protected void unregisterCarbonRuntime(CarbonRuntime carbonRuntime) {
        DataHolder.getInstance().setCarbonRuntime(null);
    }

    @Override
    public void onAllRequiredCapabilitiesAvailable() {
        try {
            String carbonRepositoryLocation = DataHolder.getInstance().getCarbonRuntime().getConfiguration().getDeploymentConfig().getRepositoryLocation();
            logger.debug("Starting Carbon Deployment Engine");
            this.deploymentEngine.start(carbonRepositoryLocation);
            OSGiServiceHolder.getInstance().setCarbonDeploymentEngine(this.deploymentEngine);
            CarbonDeploymentService deploymentService = new CarbonDeploymentService(this.deploymentEngine);
            BundleContext bundleContext = DataHolder.getInstance().getBundleContext();
            this.serviceRegistration = bundleContext.registerService(DeploymentService.class.getName(), (Object)deploymentService, null);
            logger.debug("Carbon Deployment Engine is successfully started");
        }
        catch (DeploymentEngineException e) {
            String msg = "Could not initialize carbon deployment engine";
            logger.error(msg, e);
        }
    }
}

