/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.sender;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.carbon.messaging.DefaultCarbonMessage;
import org.wso2.carbon.messaging.exceptions.MessagingException;
import org.wso2.carbon.transport.http.netty.common.Util;
import org.wso2.carbon.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.carbon.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.carbon.transport.http.netty.sender.channel.TargetChannel;
import org.wso2.carbon.transport.http.netty.sender.channel.pool.ConnectionManager;

public class TargetHandler
extends ReadTimeoutHandler {
    protected static final Logger LOG = LoggerFactory.getLogger(TargetHandler.class);
    protected CarbonCallback callback;
    protected CarbonMessage cMsg;
    protected ConnectionManager connectionManager;
    protected TargetChannel targetChannel;
    protected CarbonMessage incomingMsg;

    public TargetHandler(int timeoutSeconds) {
        super(timeoutSeconds);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtTargetConnectionInitiation(Integer.toString(ctx.hashCode()));
        }
        super.channelActive(ctx);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpResponse) {
            CarbonMessageProcessor carbonMessageProcessor;
            this.cMsg = this.setUpCarbonMessage(ctx, msg);
            if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
                HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtTargetResponseReceiving(this.cMsg);
            }
            if ((carbonMessageProcessor = HTTPTransportContextHolder.getInstance().getMessageProcessor()) != null) {
                try {
                    HTTPTransportContextHolder.getInstance().getMessageProcessor().receive(this.cMsg, this.callback);
                }
                catch (Exception e) {
                    LOG.error("Error while handover response to MessageProcessor ", e);
                }
            } else {
                LOG.error("Cannot correlate callback with request callback is null ");
            }
        } else if (this.cMsg != null) {
            if (msg instanceof LastHttpContent) {
                LastHttpContent httpContent = (LastHttpContent)msg;
                ((HTTPCarbonMessage)this.cMsg).addHttpContent(httpContent);
                this.cMsg.setEndOfMsgAdded(true);
                if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
                    HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtTargetResponseSending(this.cMsg);
                }
                this.targetChannel.setRequestWritten(false);
                this.connectionManager.returnChannel(this.targetChannel);
            } else {
                DefaultHttpContent httpContent = (DefaultHttpContent)msg;
                ((HTTPCarbonMessage)this.cMsg).addHttpContent(httpContent);
            }
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ctx.close();
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtTargetConnectionTermination(Integer.toString(ctx.hashCode()));
        }
        LOG.debug("Target channel closed.");
    }

    public void setCallback(CarbonCallback callback) {
        this.callback = callback;
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void setIncomingMsg(CarbonMessage incomingMsg) {
        this.incomingMsg = incomingMsg;
    }

    public void setTargetChannel(TargetChannel targetChannel) {
        this.targetChannel = targetChannel;
    }

    @Override
    protected void readTimedOut(ChannelHandlerContext ctx) {
        ctx.channel().close();
        if (this.targetChannel.isRequestWritten()) {
            String payload = "<errorMessage>ReadTimeoutException occurred for endpoint " + this.targetChannel.getHttpRoute().toString() + "</errorMessage>";
            CarbonMessageProcessor carbonMessageProcessor = HTTPTransportContextHolder.getInstance().getMessageProcessor();
            if (carbonMessageProcessor != null) {
                try {
                    HTTPTransportContextHolder.getInstance().getMessageProcessor().receive(this.createErrorMessage(payload), this.callback);
                }
                catch (Exception e) {
                    LOG.error("Error while handover response to MessageProcessor ", e);
                }
            } else {
                LOG.error("Cannot correlate callback with request callback is null ");
            }
        }
    }

    protected CarbonMessage setUpCarbonMessage(ChannelHandlerContext ctx, Object msg) {
        this.cMsg = new HTTPCarbonMessage();
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtTargetResponseReceiving(this.cMsg);
        }
        this.cMsg.setProperty("PORT", ((InetSocketAddress)ctx.channel().remoteAddress()).getPort());
        this.cMsg.setProperty("HOST", ((InetSocketAddress)ctx.channel().remoteAddress()).getHostName());
        this.cMsg.setProperty("DIRECTION", "DIRECTION_RESPONSE");
        this.cMsg.setProperty("CALL_BACK", this.callback);
        HttpResponse httpResponse = (HttpResponse)msg;
        this.cMsg.setProperty("HTTP_STATUS_CODE", httpResponse.getStatus().code());
        this.cMsg.setHeaders(Util.getHeaders(httpResponse).getAll());
        this.cMsg.setProperty("executor.workerpool", this.incomingMsg.getProperty("executor.workerpool"));
        return this.cMsg;
    }

    protected CarbonMessage createErrorMessage(String payload) {
        DefaultCarbonMessage response = new DefaultCarbonMessage();
        response.setStringMessageBody(payload);
        byte[] errorMessageBytes = payload.getBytes(Charset.defaultCharset());
        HashMap<String, String> transportHeaders = new HashMap<String, String>();
        transportHeaders.put("Connection", "keep-alive");
        transportHeaders.put("Accept-Encoding", "gzip");
        transportHeaders.put("Content-Type", "text/xml");
        transportHeaders.put("Content-Length", String.valueOf(errorMessageBytes.length));
        response.setHeaders(transportHeaders);
        response.setProperty("HTTP_STATUS_CODE", 504);
        response.setProperty("DIRECTION", "DIRECTION_RESPONSE");
        response.setProperty("CALL_BACK", this.callback);
        MessagingException messagingException = new MessagingException("Read Timeout", 101504);
        response.setMessagingException(messagingException);
        return response;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (ctx != null && ctx.channel().isActive()) {
            ctx.writeAndFlush(Unpooled.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
        }
    }
}

