/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.listener;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.DefaultCarbonMessage;
import org.wso2.carbon.messaging.MessageDataSource;
import org.wso2.carbon.transport.http.netty.common.Util;
import org.wso2.carbon.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.carbon.transport.http.netty.listener.ResponseContentWriter;
import org.wso2.carbon.transport.http.netty.message.HTTPCarbonMessage;

public class ResponseCallback
implements CarbonCallback {
    private ChannelHandlerContext ctx;
    private static final Logger logger = LoggerFactory.getLogger(ResponseCallback.class);
    private static final String HTTP_CONNECTION_CLOSE = "close";

    public ResponseCallback(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
    }

    @Override
    public void done(CarbonMessage cMsg) {
        block9: {
            String connection;
            block10: {
                this.handleResponsesWithoutContentLength(cMsg);
                if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
                    HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceResponseReceiving(cMsg);
                }
                HttpResponse response = Util.createHttpResponse(cMsg);
                this.ctx.write(response);
                if (cMsg.isBufferContent()) break block10;
                cMsg.setWriter(new ResponseContentWriter(this.ctx));
                break block9;
            }
            if (cMsg instanceof HTTPCarbonMessage) {
                HTTPCarbonMessage nettyCMsg = (HTTPCarbonMessage)cMsg;
                while (true) {
                    if (nettyCMsg.isEndOfMsgAdded() && nettyCMsg.isEmpty()) {
                        this.ctx.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
                        break block9;
                    }
                    HttpContent httpContent = nettyCMsg.getHttpContent();
                    if (httpContent instanceof LastHttpContent) {
                        this.ctx.writeAndFlush(httpContent);
                        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() == null) break block9;
                        HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceResponseSending(cMsg);
                        break block9;
                    }
                    this.ctx.write(httpContent);
                }
            }
            if (!(cMsg instanceof DefaultCarbonMessage)) break block9;
            DefaultCarbonMessage defaultCMsg = (DefaultCarbonMessage)cMsg;
            if (defaultCMsg.isEndOfMsgAdded() && defaultCMsg.isEmpty()) {
                this.ctx.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
                return;
            }
            do {
                ByteBuffer byteBuffer = defaultCMsg.getMessageBody();
                ByteBuf bbuf = Unpooled.wrappedBuffer(byteBuffer);
                DefaultHttpContent httpContent = new DefaultHttpContent(bbuf);
                this.ctx.write(httpContent);
            } while (!defaultCMsg.isEndOfMsgAdded() || !defaultCMsg.isEmpty());
            ChannelFuture future = this.ctx.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
            if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
                HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceResponseSending(cMsg);
            }
            if ((connection = cMsg.getHeader("Connection")) != null && HTTP_CONNECTION_CLOSE.equalsIgnoreCase(connection)) {
                future.addListener(ChannelFutureListener.CLOSE);
            }
        }
    }

    private void handleResponsesWithoutContentLength(CarbonMessage cMsg) {
        if (cMsg.isAlreadyRead()) {
            MessageDataSource messageDataSource = cMsg.getMessageDataSource();
            if (messageDataSource != null) {
                messageDataSource.serializeData();
                cMsg.setEndOfMsgAdded(true);
                cMsg.getHeaders().remove("Content-Length");
            } else {
                logger.error("Message is already built but cannot find the MessageDataSource");
            }
        }
        if (cMsg.getHeader("Transfer-Encoding") == null && cMsg.getHeader("Content-Length") == null) {
            cMsg.setHeader("Content-Length", String.valueOf(cMsg.getFullMessageLength()));
        }
    }
}

