/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.configprovider;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.configprovider.CarbonConfigurationException;
import org.wso2.carbon.kernel.configprovider.ConfigFileReader;
import org.wso2.carbon.kernel.configprovider.utils.ConfigurationUtils;
import org.wso2.carbon.kernel.utils.Utils;

public class YAMLBasedConfigFileReader
implements ConfigFileReader {
    private static final Logger logger = LoggerFactory.getLogger(YAMLBasedConfigFileReader.class);
    private String filename;

    public YAMLBasedConfigFileReader(String filename) {
        this.filename = filename;
    }

    @Override
    public Map<String, String> getDeploymentConfiguration() throws CarbonConfigurationException {
        Utils.checkSecurity();
        if (this.filename == null) {
            throw new CarbonConfigurationException("Error while reading the configuration file, filename is null");
        }
        try {
            byte[] contentBytes = Files.readAllBytes(ConfigurationUtils.getConfigurationFileLocation(this.filename));
            String yamlFileString = new String(contentBytes, StandardCharsets.UTF_8);
            return ConfigurationUtils.getDeploymentConfigMap(yamlFileString);
        }
        catch (IOException e) {
            String errorMessage = "Failed populate deployment configuration from " + this.filename;
            logger.error(errorMessage, e);
            throw new CarbonConfigurationException(errorMessage, e);
        }
    }
}

