/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.startupresolver.beans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.Bundle;
import org.wso2.carbon.kernel.internal.startupresolver.beans.Capability;
import org.wso2.carbon.kernel.internal.startupresolver.beans.CapabilityProviderCapability;
import org.wso2.carbon.kernel.startupresolver.RequiredCapabilityListener;

public class StartupComponent {
    private String name;
    private List<String> requiredServiceList = new ArrayList<String>();
    private final List<Capability> pendingCapabilityList = Collections.synchronizedList(new ArrayList());
    private RequiredCapabilityListener listener;
    private List<CapabilityProviderCapability> pendingCapabilityProviderList = new ArrayList<CapabilityProviderCapability>();
    private Bundle bundle;
    private boolean satisfied = false;

    public StartupComponent(String componentName, Bundle bundle) {
        this.name = componentName;
        this.bundle = bundle;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getRequiredServices() {
        return this.requiredServiceList;
    }

    public void addRequiredServices(List<String> requiredServiceList) {
        this.requiredServiceList.addAll(requiredServiceList);
    }

    public void addRequiredService(String requiredService) {
        this.requiredServiceList.add(requiredService);
    }

    public boolean isServiceRequired(String service) {
        return this.requiredServiceList.contains(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExpectedOrAvailableCapability(Capability capability) {
        List<Capability> list = this.pendingCapabilityList;
        synchronized (list) {
            if (this.pendingCapabilityList.contains(capability)) {
                this.pendingCapabilityList.remove(capability);
            } else {
                this.pendingCapabilityList.add(capability);
            }
        }
    }

    public List<Capability> getPendingCapabilities() {
        return Collections.unmodifiableList(this.pendingCapabilityList);
    }

    public RequiredCapabilityListener getListener() {
        return this.listener;
    }

    public void setListener(RequiredCapabilityListener listener) {
        this.listener = listener;
    }

    public void addExpectedOrAvailableCapabilityProvider(CapabilityProviderCapability capabilityProvider) {
        if (this.pendingCapabilityProviderList.contains(capabilityProvider)) {
            this.pendingCapabilityProviderList.remove(capabilityProvider);
        } else {
            this.pendingCapabilityProviderList.add(capabilityProvider);
        }
    }

    public List<CapabilityProviderCapability> getPendingCapabilityProviders() {
        return Collections.unmodifiableList(this.pendingCapabilityProviderList);
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public boolean isSatisfied() {
        return this.satisfied;
    }

    public void setSatisfied(boolean satisfied) {
        this.satisfied = satisfied;
    }

    public boolean isSatisfiable() {
        return !this.satisfied && this.pendingCapabilityList.size() == 0 && this.listener != null && this.pendingCapabilityProviderList.size() == 0;
    }

    public boolean isPending() {
        return !this.satisfied;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StartupComponent)) {
            return false;
        }
        StartupComponent other = (StartupComponent)obj;
        return this.getName().equals(other.getName()) && this.bundle.equals(other.bundle);
    }

    public int hashCode() {
        assert (false);
        return 10;
    }
}

