/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.internal.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import javax.websocket.EncodeException;
import javax.websocket.RemoteEndpoint;

public class WebSocketBasicRemoteEndpoint
implements RemoteEndpoint.Basic {
    private final ChannelHandlerContext ctx;

    public WebSocketBasicRemoteEndpoint(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public void sendText(String text) throws IOException {
        this.ctx.channel().write(new TextWebSocketFrame(text));
        this.ctx.channel().flush();
    }

    @Override
    public void sendBinary(ByteBuffer data) throws IOException {
        ByteBuf byteBuf = Unpooled.wrappedBuffer(data);
        this.ctx.channel().write(new BinaryWebSocketFrame(byteBuf));
        this.ctx.channel().flush();
    }

    @Override
    public void sendText(String partialMessage, boolean isLast) throws IOException {
        throw new UnsupportedOperationException("Method is not supported");
    }

    @Override
    public void sendBinary(ByteBuffer partialByte, boolean isLast) throws IOException {
        byte[] bytes = partialByte.array();
        ByteBuf partialByteBuf = Unpooled.wrappedBuffer(bytes);
        this.ctx.channel().write(new BinaryWebSocketFrame(isLast, 0, partialByteBuf));
        this.ctx.channel().flush();
    }

    @Override
    public OutputStream getSendStream() throws IOException {
        throw new UnsupportedOperationException("Method is not supported");
    }

    @Override
    public Writer getSendWriter() throws IOException {
        throw new UnsupportedOperationException("Method is not supported");
    }

    @Override
    public void sendObject(Object data) throws IOException, EncodeException {
        throw new UnsupportedOperationException("Method is not supported");
    }

    @Override
    public void setBatchingAllowed(boolean allowed) throws IOException {
        throw new UnsupportedOperationException("Method is not supported");
    }

    @Override
    public boolean getBatchingAllowed() {
        return false;
    }

    @Override
    public void flushBatch() throws IOException {
        throw new UnsupportedOperationException("Method is not supported");
    }

    @Override
    public void sendPing(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
        ByteBuf applicationDataBuf = Unpooled.wrappedBuffer(applicationData.array());
        this.ctx.channel().write(new PingWebSocketFrame(applicationDataBuf));
        this.ctx.channel().flush();
    }

    @Override
    public void sendPong(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
        ByteBuf applicationDataBuf = Unpooled.wrappedBuffer(applicationData.array());
        this.ctx.channel().write(new PongWebSocketFrame(applicationDataBuf));
        this.ctx.channel().flush();
    }
}

