/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.listener.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.PlatformDependent;
import java.net.InetSocketAddress;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.carbon.transport.http.netty.config.ListenerConfiguration;
import org.wso2.carbon.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.carbon.transport.http.netty.listener.http2.HTTP2ResponseCallback;
import org.wso2.carbon.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.carbon.transport.http.netty.sender.channel.pool.ConnectionManager;

public final class HTTP2SourceHandler
extends Http2ConnectionHandler
implements Http2FrameListener {
    private static final Logger log = LoggerFactory.getLogger(HTTP2SourceHandler.class);
    private Map<Integer, HTTPCarbonMessage> streamIdRequestMap = PlatformDependent.newConcurrentHashMap();
    private ConnectionManager connectionManager;
    private ListenerConfiguration listenerConfiguration;
    private ChannelHandlerContext ctx;

    HTTP2SourceHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, ConnectionManager connectionManager, ListenerConfiguration listenerConfiguration) {
        super(decoder, encoder, initialSettings);
        this.listenerConfiguration = listenerConfiguration;
        this.connectionManager = connectionManager;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.ctx = ctx;
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof HttpServerUpgradeHandler.UpgradeEvent) {
            Http2Headers headers = (Http2Headers)new DefaultHttp2Headers().status(HttpResponseStatus.OK.codeAsText()).set(new AsciiString("http-to-http2-upgrade"), new AsciiString("true"));
            this.encoder().writeHeaders(ctx, 1, headers, 0, true, ctx.newPromise());
        }
        super.userEventTriggered(ctx, evt);
    }

    @Override
    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
        HTTPCarbonMessage cMsg = this.streamIdRequestMap.get(streamId);
        if (cMsg != null) {
            cMsg.addHttpContent(new DefaultLastHttpContent(data.retain()));
            if (endOfStream) {
                cMsg.setEndOfMsgAdded(true);
                if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
                    HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceRequestSending(cMsg);
                }
            }
        }
        return data.readableBytes() + padding;
    }

    @Override
    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
        HTTPCarbonMessage cMsg = this.publishToMessageProcessor(streamId, headers);
        if (endOfStream) {
            cMsg.setEndOfMsgAdded(true);
            if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
                HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceRequestSending(cMsg);
            }
        }
    }

    @Override
    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
        this.onHeadersRead(ctx, streamId, headers, padding, endOfStream);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (ctx != null && ctx.channel().isActive()) {
            ctx.writeAndFlush(Unpooled.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ctx.close();
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceConnectionTermination(Integer.toString(ctx.hashCode()));
        }
        this.connectionManager.notifyChannelInactive();
    }

    private HTTPCarbonMessage publishToMessageProcessor(int streamId, Http2Headers headers) {
        HTTPCarbonMessage cMsg = this.setupCarbonMessage(streamId, headers);
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceRequestReceiving(cMsg);
        }
        boolean continueRequest = true;
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            continueRequest = HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeRequestContinuationValidator(cMsg, carbonMessage -> {
                CarbonCallback responseCallback = (CarbonCallback)cMsg.getProperty("CALL_BACK");
                responseCallback.done(carbonMessage);
            });
        }
        if (continueRequest) {
            CarbonMessageProcessor carbonMessageProcessor = HTTPTransportContextHolder.getInstance().getMessageProcessor();
            if (carbonMessageProcessor != null) {
                try {
                    carbonMessageProcessor.receive(cMsg, new HTTP2ResponseCallback(this.ctx, streamId));
                }
                catch (Exception e) {
                    log.error("Error while submitting CarbonMessage to CarbonMessageProcessor", e);
                }
            } else {
                log.error("Cannot find registered MessageProcessor for forward the message");
            }
        }
        return cMsg;
    }

    protected HTTPCarbonMessage setupCarbonMessage(int streamId, Http2Headers headers) {
        HTTPCarbonMessage cMsg = new HTTPCarbonMessage();
        cMsg.setProperty("PORT", ((InetSocketAddress)this.ctx.channel().remoteAddress()).getPort());
        cMsg.setProperty("HOST", ((InetSocketAddress)this.ctx.channel().remoteAddress()).getHostName());
        cMsg.setProperty("SCHEME", this.listenerConfiguration.getScheme());
        cMsg.setProperty("HTTP_VERSION", "HTTP/2.0");
        cMsg.setProperty("LISTENER_PORT", ((InetSocketAddress)this.ctx.channel().localAddress()).getPort());
        cMsg.setProperty("LISTENER_INTERFACE_ID", this.listenerConfiguration.getId());
        cMsg.setProperty("PROTOCOL", "http");
        if (this.listenerConfiguration.getSslConfig() != null) {
            cMsg.setProperty("IS_SECURED_CONNECTION", true);
        } else {
            cMsg.setProperty("IS_SECURED_CONNECTION", false);
        }
        cMsg.setProperty("LOCAL_ADDRESS", this.ctx.channel().localAddress());
        cMsg.setProperty("LOCAL_NAME", ((InetSocketAddress)this.ctx.channel().localAddress()).getHostName());
        cMsg.setProperty("REMOTE_ADDRESS", this.ctx.channel().remoteAddress());
        cMsg.setProperty("REMOTE_HOST", ((InetSocketAddress)this.ctx.channel().remoteAddress()).getHostName());
        cMsg.setProperty("REMOTE_PORT", ((InetSocketAddress)this.ctx.channel().remoteAddress()).getPort());
        ChannelHandler handler = this.ctx.handler();
        cMsg.setProperty("CHANNEL_ID", ((HTTP2SourceHandler)handler).getListenerConfiguration().getId());
        cMsg.setProperty("STREAM_ID", streamId);
        if (headers.path() != null) {
            String path = ((CharSequence)headers.getAndRemove(":path")).toString();
            cMsg.setProperty("TO", path);
            cMsg.setProperty("REQUEST_URL", path);
        }
        if (headers.method() != null) {
            String method = ((CharSequence)headers.getAndRemove(":method")).toString();
            cMsg.setProperty("HTTP_METHOD", method);
        }
        headers.getAndRemove(":authority");
        headers.getAndRemove(":scheme");
        headers.forEach(k -> cMsg.setHeader(((CharSequence)k.getKey()).toString(), ((CharSequence)k.getValue()).toString()));
        this.streamIdRequestMap.put(streamId, cMsg);
        return cMsg;
    }

    @Override
    public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) {
    }

    @Override
    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) {
    }

    @Override
    public void onSettingsAckRead(ChannelHandlerContext ctx) {
    }

    @Override
    public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) {
    }

    @Override
    public void onPingRead(ChannelHandlerContext ctx, ByteBuf data) {
    }

    @Override
    public void onPingAckRead(ChannelHandlerContext ctx, ByteBuf data) {
    }

    @Override
    public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) {
    }

    @Override
    public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) {
        if (log.isDebugEnabled() && errorCode != 0L && debugData.isReadable()) {
            int contentLength = debugData.readableBytes();
            byte[] arr = new byte[contentLength];
            debugData.readBytes(arr);
            log.debug("Error occurred while closing the client connection " + new String(arr, 0, contentLength, CharsetUtil.UTF_8));
        }
    }

    @Override
    public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) {
    }

    @Override
    public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) {
    }

    public ListenerConfiguration getListenerConfiguration() {
        return this.listenerConfiguration;
    }
}

