/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.deployment.engine.internal;

import java.io.File;
import org.wso2.carbon.deployment.engine.Artifact;

public class Utils {
    public static boolean isArtifactModified(Artifact artifact) {
        long currentTimeStamp = artifact.getLastModifiedTime();
        Utils.setArtifactLastModifiedTime(artifact);
        return currentTimeStamp != artifact.getLastModifiedTime();
    }

    public static void setArtifactLastModifiedTime(Artifact artifact) {
        File file = artifact.getFile();
        if (file != null && artifact.getLastModifiedTime() < file.lastModified()) {
            artifact.setLastModifiedTime(file.lastModified());
        }
    }

    public static File resolveFileURL(String path, String parentPath) {
        File file;
        if (path.contains(":") && !path.startsWith("file:")) {
            throw new RuntimeException("URLs other than file URLs are not supported.");
        }
        String relativeFilePath = path;
        if (path.startsWith("file:")) {
            relativeFilePath = path.substring(5);
        }
        if (!(file = new File(relativeFilePath)).isAbsolute() && !(file = new File(parentPath, relativeFilePath)).isAbsolute()) {
            throw new RuntimeException("Malformed URL : " + path);
        }
        return file;
    }
}

