/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.sender;

import io.netty.handler.codec.http.HttpRequest;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.carbon.messaging.ClientConnector;
import org.wso2.carbon.messaging.exceptions.ClientConnectorException;
import org.wso2.carbon.transport.http.netty.common.HttpRoute;
import org.wso2.carbon.transport.http.netty.common.Util;
import org.wso2.carbon.transport.http.netty.config.ConfigurationBuilder;
import org.wso2.carbon.transport.http.netty.config.SenderConfiguration;
import org.wso2.carbon.transport.http.netty.config.TransportProperty;
import org.wso2.carbon.transport.http.netty.config.TransportsConfiguration;
import org.wso2.carbon.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.carbon.transport.http.netty.listener.SourceHandler;
import org.wso2.carbon.transport.http.netty.sender.TargetHandler;
import org.wso2.carbon.transport.http.netty.sender.channel.BootstrapConfiguration;
import org.wso2.carbon.transport.http.netty.sender.channel.ChannelUtils;
import org.wso2.carbon.transport.http.netty.sender.channel.TargetChannel;
import org.wso2.carbon.transport.http.netty.sender.channel.pool.ConnectionManager;

public class HTTPClientConnector
implements ClientConnector {
    private static final Logger log = LoggerFactory.getLogger(HTTPClientConnector.class);
    private ConnectionManager connectionManager;
    private Map<String, SenderConfiguration> senderConfigurations;

    public HTTPClientConnector() {
        TransportsConfiguration transportsConfiguration = ConfigurationBuilder.getInstance().getConfiguration();
        this.init(transportsConfiguration.getSenderConfigurations(), transportsConfiguration.getTransportProperties());
    }

    public HTTPClientConnector(Set<SenderConfiguration> senderConfiguration, Set<TransportProperty> transportPropertiesSet) {
        this.init(senderConfiguration, transportPropertiesSet);
    }

    private void init(Set<SenderConfiguration> senderConfiguration, Set<TransportProperty> transportPropertiesSet) {
        if (senderConfiguration.isEmpty()) {
            log.error("Please specify at least one sender configuration");
            return;
        }
        this.senderConfigurations = senderConfiguration.stream().collect(Collectors.toMap(senderConf -> senderConf.getScheme().toLowerCase(Locale.getDefault()), config -> config));
        Map<String, Object> transportProperties = new HashMap<String, Object>();
        if (transportPropertiesSet != null && !transportPropertiesSet.isEmpty()) {
            transportProperties = transportPropertiesSet.stream().collect(Collectors.toMap(TransportProperty::getName, TransportProperty::getValue));
        }
        BootstrapConfiguration.createBootStrapConfiguration(transportProperties);
        this.connectionManager = ConnectionManager.getInstance(transportProperties);
    }

    @Override
    public boolean send(CarbonMessage msg, CarbonCallback callback, Map<String, String> parameters) throws ClientConnectorException {
        return this.send(msg, callback);
    }

    @Override
    public boolean send(CarbonMessage msg, CarbonCallback callback) throws ClientConnectorException {
        int port;
        String host;
        String protocol = (String)msg.getProperty("PROTOCOL");
        SenderConfiguration senderConfiguration = this.senderConfigurations.get(protocol.toLowerCase(Locale.getDefault()));
        Util.prepareBuiltMessageForTransfer(msg);
        Util.setupTransferEncodingForRequest(msg);
        HttpRequest httpRequest = Util.createHttpRequest(msg);
        Object hostProperty = msg.getProperty("HOST");
        if (hostProperty != null && hostProperty instanceof String) {
            host = (String)hostProperty;
        } else {
            host = "localhost";
            msg.setProperty("HOST", "localhost");
            log.debug("Cannot find property HOST of type string, hence using localhost as the host");
        }
        Object intProperty = msg.getProperty("PORT");
        if (intProperty != null && intProperty instanceof Integer) {
            port = (Integer)intProperty;
        } else {
            port = senderConfiguration.getSslConfig() != null ? 443 : 80;
            msg.setProperty("PORT", port);
            log.debug("Cannot find property PORT of type integer, hence using " + port);
        }
        HttpRoute route = new HttpRoute(host, port);
        SourceHandler srcHandler = (SourceHandler)msg.getProperty("SRC_HANDLER");
        if (srcHandler == null) {
            log.debug("SRC_HANDLER property not found in the message. Message is not originated from the HTTP Server connector");
        }
        try {
            TargetChannel targetChannel = this.connectionManager.getTargetChannel(route, srcHandler, senderConfiguration, httpRequest, msg, callback);
            if (targetChannel != null) {
                TargetHandler targetHandler = targetChannel.getTargetHandler();
                targetHandler.setCallback(callback);
                targetHandler.setIncomingMsg(msg);
                targetHandler.setConnectionManager(this.connectionManager);
                targetHandler.setTargetChannel(targetChannel);
                if (ChannelUtils.writeContent(targetChannel.getChannel(), httpRequest, msg)) {
                    targetChannel.setRequestWritten(true);
                }
            }
        }
        catch (Exception failedCause) {
            throw new ClientConnectorException(failedCause.getMessage(), failedCause);
        }
        return false;
    }

    @Override
    public String getProtocol() {
        return "http";
    }

    @Override
    public void setMessageProcessor(CarbonMessageProcessor carbonMessageProcessor) {
        HTTPTransportContextHolder.getInstance().setMessageProcessor(carbonMessageProcessor);
    }
}

