/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.sender.channel;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.DefaultCarbonMessage;
import org.wso2.carbon.transport.http.netty.common.HttpRoute;
import org.wso2.carbon.transport.http.netty.config.SenderConfiguration;
import org.wso2.carbon.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.carbon.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.carbon.transport.http.netty.sender.HTTPClientInitializer;
import org.wso2.carbon.transport.http.netty.sender.channel.BootstrapConfiguration;
import org.wso2.carbon.transport.http.netty.sender.channel.TargetChannel;

public class ChannelUtils {
    private static final Logger log = LoggerFactory.getLogger(ChannelUtils.class);

    public static ChannelFuture getNewChannelFuture(TargetChannel targetChannel, EventLoopGroup eventLoopGroup, Class eventLoopClass, HttpRoute httpRoute, SenderConfiguration senderConfiguration) {
        BootstrapConfiguration bootstrapConfiguration = BootstrapConfiguration.getInstance();
        Bootstrap clientBootstrap = new Bootstrap();
        clientBootstrap.channel(eventLoopClass);
        clientBootstrap.group(eventLoopGroup);
        clientBootstrap.option(ChannelOption.SO_KEEPALIVE, bootstrapConfiguration.isKeepAlive());
        clientBootstrap.option(ChannelOption.TCP_NODELAY, bootstrapConfiguration.isTcpNoDelay());
        clientBootstrap.option(ChannelOption.SO_REUSEADDR, bootstrapConfiguration.isSocketReuse());
        clientBootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, bootstrapConfiguration.getConnectTimeOut());
        HTTPClientInitializer httpClientInitializer = new HTTPClientInitializer(senderConfiguration);
        targetChannel.setHTTPClientInitializer(httpClientInitializer);
        clientBootstrap.handler(httpClientInitializer);
        if (log.isDebugEnabled()) {
            log.debug("Created new TCP client bootstrap connecting to {}:{} with options: {}", httpRoute.getHost(), httpRoute.getPort(), clientBootstrap);
        }
        return clientBootstrap.connect(new InetSocketAddress(httpRoute.getHost(), httpRoute.getPort()));
    }

    public static Channel openChannel(ChannelFuture channelFuture, HttpRoute httpRoute) throws Exception {
        BootstrapConfiguration bootstrapConfiguration = BootstrapConfiguration.getInstance();
        if (log.isTraceEnabled()) {
            log.trace("Waiting for operation to complete {} for {} millis", (Object)channelFuture, (Object)bootstrapConfiguration.getConnectTimeOut());
        }
        CountDownLatch channelLatch = new CountDownLatch(1);
        channelFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)cf -> channelLatch.countDown()));
        try {
            boolean wait = channelLatch.await(bootstrapConfiguration.getConnectTimeOut(), TimeUnit.MILLISECONDS);
            if (wait) {
                log.debug("Waited for connection creation in Sender");
            }
        }
        catch (InterruptedException ex) {
            throw new Exception("Interrupted while waiting for connection to " + httpRoute.toString());
        }
        Channel channel = null;
        if (channelFuture.isDone() && channelFuture.isSuccess()) {
            channel = channelFuture.channel();
            if (log.isDebugEnabled()) {
                log.debug("Creating connector to address: {}", (Object)httpRoute.toString());
            }
        } else {
            if (channelFuture.isDone() && channelFuture.isCancelled()) {
                ConnectException cause = new ConnectException("Request Cancelled, " + httpRoute.toString());
                if (channelFuture.cause() != null) {
                    cause.initCause(channelFuture.cause());
                }
                throw cause;
            }
            if (!(channelFuture.isDone() || channelFuture.isSuccess() || channelFuture.isCancelled() || channelFuture.cause() != null)) {
                throw new ConnectException("Connection timeout, " + httpRoute.toString());
            }
            ConnectException cause = new ConnectException("Connection refused, " + httpRoute.toString());
            if (channelFuture.cause() != null) {
                cause.initCause(channelFuture.cause());
            }
            throw cause;
        }
        return channel;
    }

    public static boolean writeContent(Channel channel, HttpRequest httpRequest, CarbonMessage carbonMessage) {
        block8: {
            if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
                HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtTargetRequestReceiving(carbonMessage);
            }
            channel.write(httpRequest);
            if (carbonMessage instanceof HTTPCarbonMessage) {
                HTTPCarbonMessage nettyCMsg = (HTTPCarbonMessage)carbonMessage;
                while (true) {
                    if (nettyCMsg.isEndOfMsgAdded() && nettyCMsg.isEmpty()) {
                        channel.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
                        break block8;
                    }
                    HttpContent httpContent = nettyCMsg.getHttpContent();
                    if (httpContent instanceof LastHttpContent) {
                        channel.writeAndFlush(httpContent);
                        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() == null) break block8;
                        HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtTargetRequestSending(carbonMessage);
                        break block8;
                    }
                    if (httpContent == null) continue;
                    channel.write(httpContent);
                }
            }
            if (!(carbonMessage instanceof DefaultCarbonMessage)) break block8;
            DefaultCarbonMessage defaultCMsg = (DefaultCarbonMessage)carbonMessage;
            if (defaultCMsg.isEndOfMsgAdded() && defaultCMsg.isEmpty()) {
                channel.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
                return true;
            }
            do {
                ByteBuffer byteBuffer = defaultCMsg.getMessageBody();
                ByteBuf bbuf = Unpooled.wrappedBuffer(byteBuffer);
                DefaultHttpContent httpContent = new DefaultHttpContent(bbuf);
                channel.write(httpContent);
            } while (!defaultCMsg.isEndOfMsgAdded() || !defaultCMsg.isEmpty());
            channel.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
            if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
                HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtTargetRequestSending(carbonMessage);
            }
        }
        return true;
    }
}

