/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.listener;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.AsciiString;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonTransportInitializer;
import org.wso2.carbon.transport.http.netty.common.ssl.SSLHandlerFactory;
import org.wso2.carbon.transport.http.netty.config.ListenerConfiguration;
import org.wso2.carbon.transport.http.netty.config.RequestSizeValidationConfiguration;
import org.wso2.carbon.transport.http.netty.listener.CustomHttpObjectAggregator;
import org.wso2.carbon.transport.http.netty.listener.CustomHttpRequestDecoder;
import org.wso2.carbon.transport.http.netty.listener.SourceHandler;
import org.wso2.carbon.transport.http.netty.listener.http2.HTTP2SourceHandlerBuilder;
import org.wso2.carbon.transport.http.netty.listener.http2.HTTPProtocolNegotiationHandler;
import org.wso2.carbon.transport.http.netty.sender.channel.pool.ConnectionManager;

public class HTTPServerChannelInitializer
extends ChannelInitializer<SocketChannel>
implements CarbonTransportInitializer {
    private static final Logger log = LoggerFactory.getLogger(HTTPServerChannelInitializer.class);
    private ConnectionManager connectionManager;
    private Map<Integer, ListenerConfiguration> listenerConfigurationMap = new HashMap<Integer, ListenerConfiguration>();
    private Map<Integer, SslContext> sslContextMap = new HashMap<Integer, SslContext>();

    public void registerListenerConfig(ListenerConfiguration listenerConfiguration, SslContext sslContext) {
        this.listenerConfigurationMap.put(listenerConfiguration.getPort(), listenerConfiguration);
        this.sslContextMap.put(listenerConfiguration.getPort(), sslContext);
    }

    public void unRegisterListenerConfig(ListenerConfiguration listenerConfiguration) {
        this.listenerConfigurationMap.remove(listenerConfiguration.getPort());
        this.sslContextMap.remove(listenerConfiguration.getPort());
    }

    @Override
    public void setup(Map<String, String> parameters) {
    }

    public void setupConnectionManager(Map<String, Object> transportProperties) {
        try {
            this.connectionManager = ConnectionManager.getInstance(transportProperties);
        }
        catch (Exception e) {
            log.error("Error initializing the transport ", e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void initChannel(SocketChannel ch) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Initializing source channel pipeline");
        }
        int port = ch.localAddress().getPort();
        ListenerConfiguration listenerConfiguration = this.listenerConfigurationMap.get(port);
        ChannelPipeline p = ch.pipeline();
        if (listenerConfiguration.isHttp2()) {
            SslContext sslContext = this.sslContextMap.get(port);
            if (this.sslContextMap.get(port) != null) {
                this.configureHttp2TLSPipeline(ch, listenerConfiguration, sslContext);
            } else {
                this.configureHttp2Pipeline(ch, listenerConfiguration);
            }
        } else {
            if (listenerConfiguration.getSslConfig() != null) {
                SSLEngine sslEngine = new SSLHandlerFactory(listenerConfiguration.getSslConfig()).build();
                ch.pipeline().addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
            }
            p.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
            this.configureHTTPPipeline(ch, listenerConfiguration);
        }
    }

    private void configureHttp2TLSPipeline(SocketChannel ch, ListenerConfiguration listenerConfiguration, SslContext sslContext) {
        ChannelPipeline p = ch.pipeline();
        p.addLast("ssl", (ChannelHandler)sslContext.newHandler(ch.alloc()));
        p.addLast("http-upgrade", (ChannelHandler)new HTTPProtocolNegotiationHandler(this.connectionManager, listenerConfiguration));
    }

    private void configureHttp2Pipeline(SocketChannel ch, ListenerConfiguration listenerConfiguration) {
        ChannelPipeline p = ch.pipeline();
        HttpServerCodec sourceCodec = new HttpServerCodec();
        HttpServerUpgradeHandler.UpgradeCodecFactory upgradeCodecFactory = protocol -> {
            if (AsciiString.contentEquals(Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, protocol)) {
                return new Http2ServerUpgradeCodec("http2-handler", new HTTP2SourceHandlerBuilder(this.connectionManager, listenerConfiguration).build());
            }
            return null;
        };
        p.addLast("encoder", (ChannelHandler)sourceCodec);
        p.addLast("http2-upgrade", (ChannelHandler)new HttpServerUpgradeHandler(sourceCodec, upgradeCodecFactory));
        this.configureHTTPPipeline(ch, listenerConfiguration);
    }

    public void configureHTTPPipeline(SocketChannel ch, ListenerConfiguration listenerConfiguration) {
        ChannelPipeline p = ch.pipeline();
        if (RequestSizeValidationConfiguration.getInstance().isHeaderSizeValidation()) {
            p.addLast("decoder", (ChannelHandler)new CustomHttpRequestDecoder());
        } else {
            p.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        }
        if (RequestSizeValidationConfiguration.getInstance().isRequestSizeValidation()) {
            p.addLast("custom-aggregator", (ChannelHandler)new CustomHttpObjectAggregator());
        }
        p.addLast("compressor", (ChannelHandler)new HttpContentCompressor());
        p.addLast("chunkWriter", (ChannelHandler)new ChunkedWriteHandler());
        try {
            int socketIdleTimeout = listenerConfiguration.getSocketIdleTimeout(120000);
            p.addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(socketIdleTimeout, socketIdleTimeout, socketIdleTimeout, TimeUnit.MILLISECONDS));
            p.addLast("handler", (ChannelHandler)new SourceHandler(this.connectionManager, listenerConfiguration));
        }
        catch (Exception e) {
            log.error("Cannot Create SourceHandler ", e);
        }
    }

    @Override
    public boolean isServerInitializer() {
        return true;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }
}

