/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.entitywriter;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.msf4j.internal.entitywriter.EntityWriter;

public class InputStreamEntityWriter
implements EntityWriter<InputStream> {
    public static final int DEFAULT_CHUNK_SIZE = 1024;

    @Override
    public Class<InputStream> getType() {
        return InputStream.class;
    }

    @Override
    public void writeData(CarbonMessage carbonMessage, InputStream ipStream, String mediaType, int chunkSize, CarbonCallback cb) {
        try {
            int len;
            if (chunkSize == 0 || chunkSize == -1) {
                chunkSize = 1024;
            }
            carbonMessage.setHeader("Transfer-Encoding", "chunked");
            carbonMessage.setHeader("Content-Type", mediaType);
            carbonMessage.setBufferContent(false);
            cb.done(carbonMessage);
            byte[] data = new byte[chunkSize];
            while ((len = ipStream.read(data)) != -1) {
                carbonMessage.addMessageBody(ByteBuffer.wrap(data, 0, len));
            }
            ipStream.close();
            carbonMessage.setEndOfMsgAdded(true);
        }
        catch (IOException e) {
            throw new RuntimeException("Error occurred while reading from InputStream", e);
        }
    }
}

