/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.listener;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.config.RequestSizeValidationConfiguration;

public class CustomHttpObjectAggregator
extends HttpObjectAggregator {
    private static final Logger log = LoggerFactory.getLogger(CustomHttpObjectAggregator.class);
    private RequestSizeValidationConfiguration requestSizeValidationConfig;

    public CustomHttpObjectAggregator(RequestSizeValidationConfiguration requestSizeValidationConfig) {
        super(requestSizeValidationConfig.getRequestMaxSize());
        this.requestSizeValidationConfig = requestSizeValidationConfig;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, HttpObject msg, List<Object> out) throws Exception {
        try {
            super.decode(ctx, msg, out);
        }
        catch (Exception e) {
            log.warn("Message length validation failed");
            Iterator iterator = ctx.pipeline().iterator();
            boolean canRemove = false;
            while (iterator.hasNext()) {
                Map.Entry channelHandlerEntry = (Map.Entry)iterator.next();
                if (((String)channelHandlerEntry.getKey()).equalsIgnoreCase(ctx.name())) {
                    canRemove = true;
                }
                if (!canRemove || ((String)channelHandlerEntry.getKey()).equalsIgnoreCase(ctx.name())) continue;
                ctx.pipeline().remove((String)channelHandlerEntry.getKey());
            }
            String rejectMessage = this.requestSizeValidationConfig.getRequestRejectMessage();
            byte[] errorMessageBytes = rejectMessage.getBytes(Charset.defaultCharset());
            ByteBuf content = Unpooled.wrappedBuffer(errorMessageBytes);
            DefaultFullHttpResponse rejectResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf(this.requestSizeValidationConfig.getRequestRejectStatusCode()), content);
            rejectResponse.headers().set("Content-Length", (Object)errorMessageBytes.length);
            rejectResponse.headers().set("Content-Type", (Object)this.requestSizeValidationConfig.getRequestRejectMsgContentType());
            ctx.writeAndFlush(rejectResponse);
        }
    }
}

