/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl;

import java.util.concurrent.Semaphore;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contractimpl.HttpResponseStatus;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

public class HttpResponseStatusFuture
implements HttpResponseFuture {
    private HTTPCarbonMessage httpCarbonMessage;
    private Throwable throwable;
    private Throwable returnError;
    private Semaphore executionWaitSem;

    @Override
    public void notifyHttpListener(HTTPCarbonMessage httpCarbonMessage) {
        this.httpCarbonMessage = httpCarbonMessage;
        if (this.executionWaitSem != null) {
            this.executionWaitSem.release();
        }
    }

    @Override
    public void notifyHttpListener(Throwable throwable) {
        this.throwable = throwable;
        if (this.executionWaitSem != null) {
            this.executionWaitSem.release();
        }
    }

    public HttpResponseStatusFuture sync() throws InterruptedException {
        this.executionWaitSem = new Semaphore(0);
        if (this.httpCarbonMessage == null && this.throwable == null) {
            this.executionWaitSem.acquire();
        }
        if (this.httpCarbonMessage != null) {
            this.returnError = null;
            this.httpCarbonMessage = null;
        }
        if (this.throwable != null) {
            this.returnError = this.throwable;
            this.throwable = null;
        }
        return this;
    }

    public HttpResponseStatus getStatus() {
        return this.returnError != null ? new HttpResponseStatus(this.returnError) : new HttpResponseStatus(null);
    }

    @Override
    public void setHttpConnectorListener(HttpConnectorListener connectorListener) {
    }

    @Override
    public void removeHttpListener() {
    }
}

