/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.sender;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.message.DefaultListener;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

public class RedirectUtil {
    private static final Logger log = LoggerFactory.getLogger(RedirectUtil.class);

    public static HTTPCarbonMessage createRedirectCarbonRequest(String redirectionUrl, String redirectionMethod, int statusCode, ChannelHandlerContext ctx, List<Map.Entry<String, String>> headers) throws MalformedURLException {
        if (log.isDebugEnabled()) {
            log.debug("Create redirect request with http method  : " + redirectionMethod);
        }
        URL locationUrl = new URL(redirectionUrl);
        HttpMethod httpMethod = new HttpMethod(redirectionMethod);
        HTTPCarbonMessage httpCarbonRequest = new HTTPCarbonMessage(new DefaultHttpRequest(HttpVersion.HTTP_1_1, httpMethod, ""), new DefaultListener(ctx));
        httpCarbonRequest.setProperty("port", locationUrl.getPort() != -1 ? locationUrl.getPort() : RedirectUtil.getDefaultPort(locationUrl.getProtocol()));
        httpCarbonRequest.setProperty("PROTOCOL", locationUrl.getProtocol());
        httpCarbonRequest.setProperty("host", locationUrl.getHost());
        httpCarbonRequest.setProperty("HTTP_METHOD", redirectionMethod);
        httpCarbonRequest.setProperty("REQUEST_URL", locationUrl.getFile());
        httpCarbonRequest.setProperty("TO", locationUrl.getFile());
        StringBuilder host = new StringBuilder(locationUrl.getHost());
        if (locationUrl.getPort() != -1 && locationUrl.getPort() != 80 && locationUrl.getPort() != 443) {
            host.append(":").append(locationUrl.getPort());
        }
        httpCarbonRequest.removeHeader("HTTP_METHOD");
        headers.stream().forEach(entry -> httpCarbonRequest.setHeader((String)entry.getKey(), (String)entry.getValue()));
        if (statusCode == 303) {
            httpCarbonRequest.removeHeader(HttpHeaderNames.CONTENT_LENGTH.toString());
            httpCarbonRequest.removeHeader(HttpHeaderNames.TRANSFER_ENCODING.toString());
        }
        httpCarbonRequest.setHeader(HttpHeaderNames.HOST.toString(), host.toString());
        httpCarbonRequest.completeMessage();
        return httpCarbonRequest;
    }

    public static String getResolvedRedirectURI(String locationHeaderVal, HTTPCarbonMessage originalRequest) throws URISyntaxException, UnsupportedEncodingException {
        String baseURIAsString;
        URI location = new URI(locationHeaderVal);
        if (!location.isAbsolute() && (baseURIAsString = (String)originalRequest.getProperty("TO")) != null) {
            URI baseUri = new URI(baseURIAsString);
            location = baseUri.resolve(location.normalize());
        }
        return location.toString();
    }

    private static int getDefaultPort(String protocol) {
        return "https".equals(protocol) ? 443 : 80;
    }
}

