/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.entitywriter;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Executors;
import javax.ws.rs.core.StreamingOutput;
import org.wso2.msf4j.internal.entitywriter.EntityWriter;
import org.wso2.transport.http.netty.contract.ServerConnectorException;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.transport.http.netty.message.HttpMessageDataStreamer;

public class StreamingOutputEntityWriter
implements EntityWriter<StreamingOutput> {
    @Override
    public Class<StreamingOutput> getType() {
        return StreamingOutput.class;
    }

    @Override
    public void writeData(HTTPCarbonMessage carbonMessage, StreamingOutput output, String mediaType, int chunkSize, HTTPCarbonMessage responder) {
        try {
            carbonMessage.setHeader(HttpHeaderNames.CONTENT_TYPE.toString(), mediaType);
            carbonMessage.setHeader(HttpHeaderNames.TRANSFER_ENCODING.toString(), "chunked");
            Executors.newSingleThreadExecutor().execute(() -> {
                try {
                    responder.respond(carbonMessage);
                }
                catch (ServerConnectorException e) {
                    throw new RuntimeException("Error while sending the response.", e);
                }
            });
            OutputStream outputStream = new HttpMessageDataStreamer(carbonMessage).getOutputStream();
            output.write(outputStream);
            outputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error occurred while streaming output", e);
        }
    }
}

