/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.listener.http2;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.util.internal.PlatformDependent;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2MessageStateContext;
import org.wso2.transport.http.netty.contractimpl.common.states.Http2StateUtil;
import org.wso2.transport.http.netty.contractimpl.listener.HttpServerChannelInitializer;
import org.wso2.transport.http.netty.contractimpl.listener.states.http2.ReceivingHeaders;
import org.wso2.transport.http.netty.message.Http2DataFrame;
import org.wso2.transport.http.netty.message.Http2HeadersFrame;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;
import org.wso2.transport.http.netty.message.HttpCarbonRequest;

public final class Http2SourceHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(Http2SourceHandler.class);
    private Map<Integer, HttpCarbonMessage> streamIdRequestMap = PlatformDependent.newConcurrentHashMap();
    private ChannelHandlerContext ctx;
    private ServerConnectorFuture serverConnectorFuture;
    private HttpServerChannelInitializer serverChannelInitializer;
    private Http2ConnectionEncoder encoder;
    private Http2Connection conn;
    private String interfaceId;
    private String serverName;
    private String remoteAddress;
    private Map<String, GenericObjectPool> targetChannelPool;

    Http2SourceHandler(HttpServerChannelInitializer serverChannelInitializer, Http2ConnectionEncoder encoder, String interfaceId, Http2Connection conn, ServerConnectorFuture serverConnectorFuture, String serverName) {
        this.serverChannelInitializer = serverChannelInitializer;
        this.encoder = encoder;
        this.interfaceId = interfaceId;
        this.serverConnectorFuture = serverConnectorFuture;
        this.conn = conn;
        this.serverName = serverName;
        this.targetChannelPool = new ConcurrentHashMap<String, GenericObjectPool>();
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.ctx = ctx;
        SocketAddress address = ctx.channel().remoteAddress();
        if (address instanceof InetSocketAddress) {
            this.remoteAddress = ((InetSocketAddress)address).getAddress().toString();
            if (this.remoteAddress.startsWith("/")) {
                this.remoteAddress = this.remoteAddress.substring(1);
            }
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof HttpServerUpgradeHandler.UpgradeEvent) {
            FullHttpRequest upgradedRequest = ((HttpServerUpgradeHandler.UpgradeEvent)evt).upgradeRequest();
            DefaultHttpRequest httpRequest = new DefaultHttpRequest(new HttpVersion("HTTP/2.0", true), upgradedRequest.method(), upgradedRequest.uri(), upgradedRequest.headers());
            HttpCarbonRequest requestCarbonMessage = Http2StateUtil.setupCarbonRequest(httpRequest, this);
            requestCarbonMessage.addHttpContent(new DefaultLastHttpContent(upgradedRequest.content()));
            Http2StateUtil.notifyRequestListener(this, requestCarbonMessage, 1);
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof Http2HeadersFrame) {
            Http2HeadersFrame headersFrame = (Http2HeadersFrame)msg;
            Http2MessageStateContext http2MessageStateContext = new Http2MessageStateContext();
            http2MessageStateContext.setListenerState(new ReceivingHeaders(this, http2MessageStateContext));
            http2MessageStateContext.getListenerState().readInboundRequestHeaders(headersFrame);
        } else if (msg instanceof Http2DataFrame) {
            Http2DataFrame dataFrame = (Http2DataFrame)msg;
            int streamId = dataFrame.getStreamId();
            HttpCarbonMessage sourceReqCMsg = this.streamIdRequestMap.get(streamId);
            if (sourceReqCMsg == null) {
                dataFrame.getData().release();
            } else {
                sourceReqCMsg.getHttp2MessageStateContext().getListenerState().readInboundRequestBody(this, dataFrame);
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        this.destroy();
        this.closeTargetChannels();
        ctx.fireChannelInactive();
    }

    @Override
    public void channelUnregistered(ChannelHandlerContext ctx) {
        this.destroy();
        ctx.fireChannelUnregistered();
    }

    private void destroy() {
        this.streamIdRequestMap.clear();
    }

    private void closeTargetChannels() {
        this.targetChannelPool.forEach((hostPortKey, genericObjectPool) -> {
            try {
                this.targetChannelPool.remove(hostPortKey).close();
            }
            catch (Exception e) {
                LOG.error("Couldn't close target channel socket connections", e);
            }
        });
    }

    public Map<Integer, HttpCarbonMessage> getStreamIdRequestMap() {
        return this.streamIdRequestMap;
    }

    public ChannelHandlerContext getChannelHandlerContext() {
        return this.ctx;
    }

    public ServerConnectorFuture getServerConnectorFuture() {
        return this.serverConnectorFuture;
    }

    public HttpServerChannelInitializer getServerChannelInitializer() {
        return this.serverChannelInitializer;
    }

    public Http2ConnectionEncoder getEncoder() {
        return this.encoder;
    }

    public Http2Connection getConnection() {
        return this.conn;
    }

    public String getInterfaceId() {
        return this.interfaceId;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public Map<String, GenericObjectPool> getTargetChannelPool() {
        return this.targetChannelPool;
    }

    public ChannelHandlerContext getInboundChannelContext() {
        return this.ctx;
    }
}

