/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.message;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.message.BackPressureListener;

public class PassthroughBackPressureListener
implements BackPressureListener {
    private static final Logger LOG = LoggerFactory.getLogger(PassthroughBackPressureListener.class);
    private Channel inChannel;

    public PassthroughBackPressureListener(ChannelHandlerContext inContext) {
        this.inChannel = inContext.channel();
    }

    @Override
    public void onUnWritable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Read disabled for inChannel {}", (Object)this.inChannel.id());
        }
        this.inChannel.config().setAutoRead(false);
    }

    @Override
    public void onWritable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Read enabled for inChannel {}", (Object)this.inChannel.id());
        }
        this.inChannel.config().setAutoRead(true);
    }
}

