/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender.http2;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contractimpl.DefaultHttpResponseFuture;
import org.wso2.transport.http.netty.contractimpl.sender.http2.Http2ClientChannel;
import org.wso2.transport.http.netty.message.BackPressureObservable;
import org.wso2.transport.http.netty.message.DefaultBackPressureObservable;
import org.wso2.transport.http.netty.message.Http2PushPromise;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;
import org.wso2.transport.http.netty.message.HttpCarbonResponse;

public class OutboundMsgHolder {
    private HttpCarbonMessage requestCarbonMessage;
    private BlockingQueue<Http2PushPromise> promises;
    private ConcurrentHashMap<Integer, HttpCarbonResponse> pushResponsesMap;
    private HttpCarbonResponse response;
    private HttpResponseFuture responseFuture;
    private Http2ClientChannel http2ClientChannel;
    private boolean allPromisesReceived = false;
    private long lastReadWriteTime;
    private boolean requestWritten;
    private boolean firstContentWritten;
    private AtomicBoolean streamWritable = new AtomicBoolean(true);
    private final BackPressureObservable backPressureObservable = new DefaultBackPressureObservable();

    public OutboundMsgHolder(HttpCarbonMessage httpOutboundRequest) {
        this.requestCarbonMessage = httpOutboundRequest;
        this.promises = new LinkedBlockingQueue<Http2PushPromise>();
        this.pushResponsesMap = new ConcurrentHashMap();
        this.responseFuture = new DefaultHttpResponseFuture(this);
    }

    public void setHttp2ClientChannel(Http2ClientChannel http2ClientChannel) {
        this.http2ClientChannel = http2ClientChannel;
    }

    public HttpCarbonMessage getRequest() {
        return this.requestCarbonMessage;
    }

    public HttpResponseFuture getResponseFuture() {
        return this.responseFuture;
    }

    public Http2ClientChannel getHttp2ClientChannel() {
        return this.http2ClientChannel;
    }

    public void addPromise(Http2PushPromise pushPromise) {
        this.promises.add(pushPromise);
        this.responseFuture.notifyPromiseAvailability();
        this.responseFuture.notifyPushPromise();
    }

    public void addPushResponse(int streamId, HttpCarbonResponse pushResponse) {
        this.pushResponsesMap.put(streamId, pushResponse);
        this.responseFuture.notifyPushResponse(streamId, pushResponse);
    }

    public boolean isAllPromisesReceived() {
        return this.allPromisesReceived;
    }

    public void markNoPromisesReceived() {
        this.allPromisesReceived = true;
        this.responseFuture.notifyPromiseAvailability();
    }

    public HttpCarbonResponse getPushResponse(int steamId) {
        return this.pushResponsesMap.get(steamId);
    }

    public HttpCarbonResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpCarbonResponse response) {
        this.response = response;
        this.allPromisesReceived = true;
        this.responseFuture.notifyPromiseAvailability();
        this.responseFuture.notifyHttpListener(response);
    }

    public boolean hasPromise() {
        return !this.promises.isEmpty();
    }

    public Http2PushPromise getNextPromise() {
        return (Http2PushPromise)this.promises.poll();
    }

    long getLastReadWriteTime() {
        return this.lastReadWriteTime;
    }

    void setLastReadWriteTime(long lastReadWriteTime) {
        this.lastReadWriteTime = lastReadWriteTime;
    }

    boolean isRequestWritten() {
        return this.requestWritten;
    }

    public void setRequestWritten(boolean requestWritten) {
        this.requestWritten = requestWritten;
    }

    boolean isFirstContentWritten() {
        return this.firstContentWritten;
    }

    void setFirstContentWritten(boolean firstContentWritten) {
        this.firstContentWritten = firstContentWritten;
    }

    boolean isStreamWritable() {
        return this.streamWritable.get();
    }

    public void setStreamWritable(boolean streamWritable) {
        this.streamWritable.set(streamWritable);
    }

    public BackPressureObservable getBackPressureObservable() {
        return this.backPressureObservable;
    }
}

