/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.common.ssl;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLConfig {
    private static final Logger LOG = LoggerFactory.getLogger(SSLConfig.class);
    private static final String SEPARATOR = ",";
    private File keyStore;
    private String keyStorePass;
    private String certPass;
    private File trustStore;
    private String trustStorePass;
    private String sslProtocol;
    private String tlsStoreType;
    private String[] cipherSuites;
    private String[] enableProtocols;
    private boolean enableSessionCreation = true;
    private boolean needClientAuth;
    private boolean wantClientAuth;
    private String[] serverNames;
    private String[] sniMatchers;
    private boolean validateCertEnabled;
    private int cacheSize = 50;
    private int cacheValidityPeriod = 15;
    private boolean ocspStaplingEnabled = false;
    private boolean hostNameVerificationEnabled = true;
    private File serverKeyFile;
    private File serverCertificates;
    private File clientKeyFile;
    private File clientCertificates;
    private File serverTrustCertificates;
    private File clientTrustCertificates;
    private String serverKeyPassword;
    private String clientKeyPassword;
    private int sessionTimeOut;
    private long handshakeTimeOut;
    private boolean disableSsl = false;
    private boolean useJavaDefaults = false;

    public String getCertPass() {
        return this.certPass;
    }

    public SSLConfig setCertPass(String certPass) {
        this.certPass = certPass;
        return this;
    }

    public File getTrustStore() {
        return this.trustStore;
    }

    public SSLConfig setTrustStore(File trustStore) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using trust store {}", (Object)trustStore);
        }
        this.trustStore = trustStore;
        return this;
    }

    public String getTrustStorePass() {
        return this.trustStorePass;
    }

    public SSLConfig setTrustStorePass(String trustStorePass) {
        this.trustStorePass = trustStorePass;
        return this;
    }

    public File getKeyStore() {
        return this.keyStore;
    }

    public String getKeyStorePass() {
        return this.keyStorePass;
    }

    public String[] getSniMatchers() {
        return this.sniMatchers == null ? null : (String[])this.sniMatchers.clone();
    }

    public void setSniMatchers(String sniMatchers) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using sniMatchers {}", (Object)sniMatchers);
        }
        this.sniMatchers = sniMatchers.split(SEPARATOR);
    }

    public String[] getServerNames() {
        return this.serverNames == null ? null : (String[])this.serverNames.clone();
    }

    public void setServerNames(String serverNames) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using serverNames {}", (Object)serverNames);
        }
        this.serverNames = serverNames.replaceAll("\\s+", "").split(SEPARATOR);
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set WantClientAuth {}", (Object)wantClientAuth);
        }
        this.wantClientAuth = wantClientAuth;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set NeedClientAuth {}", (Object)needClientAuth);
        }
        this.needClientAuth = needClientAuth;
    }

    public void setSSLProtocol(String sslProtocol) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set SSLProtocol {}", (Object)sslProtocol);
        }
        this.sslProtocol = sslProtocol;
    }

    public String getSSLProtocol() {
        return this.sslProtocol;
    }

    public String getTLSStoreType() {
        return this.tlsStoreType;
    }

    public void setTLSStoreType(String tlsStoreType) {
        this.tlsStoreType = tlsStoreType;
    }

    public boolean isEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public void setEnableSessionCreation(boolean enableSessionCreation) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Enable Session Creation {}", (Object)enableSessionCreation);
        }
        this.enableSessionCreation = enableSessionCreation;
    }

    public String[] getEnableProtocols() {
        return this.enableProtocols == null ? null : (String[])this.enableProtocols.clone();
    }

    public void setEnableProtocols(String enableProtocols) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set enable protocols {}", (Object)enableProtocols);
        }
        this.enableProtocols = enableProtocols.replaceAll("\\s+", "").split(SEPARATOR);
    }

    public String[] getCipherSuites() {
        return this.cipherSuites == null ? null : (String[])this.cipherSuites.clone();
    }

    public void setCipherSuites(String cipherSuites) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set supported cipherSuites {}", (Object)cipherSuites);
        }
        this.cipherSuites = cipherSuites.replaceAll("\\s+", "").split(SEPARATOR);
    }

    public void setKeyStore(File keyStore) {
        this.keyStore = keyStore;
    }

    public void setKeyStorePass(String keyStorePass) {
        this.keyStorePass = keyStorePass;
    }

    public boolean isValidateCertEnabled() {
        return this.validateCertEnabled;
    }

    public void setValidateCertEnabled(boolean validateCertEnabled) {
        this.validateCertEnabled = validateCertEnabled;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public int getCacheValidityPeriod() {
        return this.cacheValidityPeriod;
    }

    public void setCacheValidityPeriod(int cacheValidityPeriod) {
        this.cacheValidityPeriod = cacheValidityPeriod;
    }

    public boolean isOcspStaplingEnabled() {
        return this.ocspStaplingEnabled;
    }

    public void setOcspStaplingEnabled(boolean ocspStaplingEnabled) {
        this.ocspStaplingEnabled = ocspStaplingEnabled;
    }

    public boolean isHostNameVerificationEnabled() {
        return this.hostNameVerificationEnabled;
    }

    public void setHostNameVerificationEnabled(boolean hostNameVerificationEnabled) {
        this.hostNameVerificationEnabled = hostNameVerificationEnabled;
    }

    public File getServerKeyFile() {
        return this.serverKeyFile;
    }

    public File getServerCertificates() {
        return this.serverCertificates;
    }

    public File getClientKeyFile() {
        return this.clientKeyFile;
    }

    public File getClientCertificates() {
        return this.clientCertificates;
    }

    public File getServerTrustCertificates() {
        return this.serverTrustCertificates;
    }

    public File getClientTrustCertificates() {
        return this.clientTrustCertificates;
    }

    public void setServerKeyFile(File serverKeyFile) {
        this.serverKeyFile = serverKeyFile;
    }

    public void setServerCertificates(File serverCertificates) {
        this.serverCertificates = serverCertificates;
    }

    public void setClientKeyFile(File clientKeyFile) {
        this.clientKeyFile = clientKeyFile;
    }

    public void setClientCertificates(File clientCertificates) {
        this.clientCertificates = clientCertificates;
    }

    public void setServerTrustCertificates(File serverTrustCertificates) {
        this.serverTrustCertificates = serverTrustCertificates;
    }

    public void setClientTrustCertificates(File clientTrustCertificates) {
        this.clientTrustCertificates = clientTrustCertificates;
    }

    public String getServerKeyPassword() {
        return this.serverKeyPassword;
    }

    public void setServerKeyPassword(String serverKeyPassword) {
        this.serverKeyPassword = serverKeyPassword;
    }

    public String getClientKeyPassword() {
        return this.clientKeyPassword;
    }

    public void setClientKeyPassword(String clientKeyPassword) {
        this.clientKeyPassword = clientKeyPassword;
    }

    public int getSessionTimeOut() {
        return this.sessionTimeOut;
    }

    public void setSessionTimeOut(int sessionTimeOut) {
        this.sessionTimeOut = sessionTimeOut;
    }

    public long getHandshakeTimeOut() {
        return this.handshakeTimeOut;
    }

    public void setHandshakeTimeOut(long handshakeTimeOut) {
        this.handshakeTimeOut = handshakeTimeOut;
    }

    public boolean isDisableSsl() {
        return this.disableSsl;
    }

    public void disableSsl() {
        this.disableSsl = true;
    }

    public boolean useJavaDefaults() {
        return this.useJavaDefaults;
    }

    public void setUseJavaDefaults() {
        this.useJavaDefaults = true;
    }
}

