/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.config.model;

import java.util.Properties;
import org.wso2.carbon.config.annotation.Configuration;
import org.wso2.carbon.config.annotation.Element;
import org.wso2.carbon.config.annotation.Ignore;
import org.wso2.carbon.kernel.config.model.PortsConfig;
import org.wso2.carbon.kernel.config.model.StartupResolverConfig;
import org.wso2.carbon.kernel.internal.config.JMXConfiguration;
import org.wso2.carbon.kernel.internal.utils.Utils;

@Configuration(namespace="wso2.carbon", description="Carbon Configuration Parameters")
public class CarbonConfiguration {
    @Element(description="value to uniquely identify a server")
    private String id = "carbon-kernel";
    @Element(description="server name")
    private String name = "WSO2 Carbon Kernel";
    @Ignore
    private String version;
    private String tenant = "default";
    @Element(description="ports used by this server")
    private PortsConfig ports = new PortsConfig();
    @Element(description="StartupOrderResolver related configurations")
    private StartupResolverConfig startupResolver = new StartupResolverConfig();
    @Element(description="JMX Configuration")
    private JMXConfiguration jmx = new JMXConfiguration();

    public CarbonConfiguration() {
        Properties properties = Utils.loadProjectProperties();
        this.version = properties.getProperty("MAVEN_PROJECT_VERSION");
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getTenant() {
        return this.tenant;
    }

    public PortsConfig getPortsConfig() {
        return this.ports;
    }

    public StartupResolverConfig getStartupResolverConfig() {
        return this.startupResolver;
    }

    public JMXConfiguration getJmxConfiguration() {
        return this.jmx;
    }
}

