/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender.states;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contract.exceptions.ClientConnectorException;
import org.wso2.transport.http.netty.contract.exceptions.EndpointTimeOutException;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.common.states.SenderReqRespStateManager;
import org.wso2.transport.http.netty.contractimpl.sender.TargetHandler;
import org.wso2.transport.http.netty.contractimpl.sender.states.ReceivingHeaders;
import org.wso2.transport.http.netty.contractimpl.sender.states.RequestCompleted;
import org.wso2.transport.http.netty.contractimpl.sender.states.SenderState;
import org.wso2.transport.http.netty.internal.HandlerExecutor;
import org.wso2.transport.http.netty.internal.HttpTransportContextHolder;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class SendingEntityBody
implements SenderState {
    private static final Logger LOG = LoggerFactory.getLogger(SendingEntityBody.class);
    private final SenderReqRespStateManager senderReqRespStateManager;
    private final HandlerExecutor handlerExecutor;
    private final HttpResponseFuture httpInboundResponseFuture;

    SendingEntityBody(SenderReqRespStateManager senderReqRespStateManager, HttpResponseFuture httpInboundResponseFuture) {
        this.senderReqRespStateManager = senderReqRespStateManager;
        this.handlerExecutor = HttpTransportContextHolder.getInstance().getHandlerExecutor();
        this.httpInboundResponseFuture = httpInboundResponseFuture;
    }

    @Override
    public void writeOutboundRequestHeaders(HttpCarbonMessage httpOutboundRequest) {
        LOG.warn("writeOutboundRequestHeaders {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void writeOutboundRequestEntity(HttpCarbonMessage httpOutboundRequest, HttpContent httpContent) {
        if (Util.isLastHttpContent(httpContent)) {
            this.writeOutboundRequestBody(httpContent);
            if (this.handlerExecutor != null) {
                this.handlerExecutor.executeAtTargetRequestSending(httpOutboundRequest);
            }
        } else {
            this.senderReqRespStateManager.nettyTargetChannel.writeAndFlush(httpContent);
        }
    }

    @Override
    public void readInboundResponseHeaders(TargetHandler targetHandler, HttpResponse httpInboundResponse) {
        if (httpInboundResponse.status().code() != HttpResponseStatus.CONTINUE.code()) {
            targetHandler.getOutboundRequestMsg().setIoException(new IOException("Inbound response message already received"));
            this.senderReqRespStateManager.state = new ReceivingHeaders(this.senderReqRespStateManager);
            this.senderReqRespStateManager.readInboundResponseHeaders(targetHandler, httpInboundResponse);
        }
    }

    @Override
    public void readInboundResponseEntityBody(ChannelHandlerContext ctx, HttpContent httpContent, HttpCarbonMessage inboundResponseMsg) {
        LOG.warn("readInboundResponseEntityBody {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void handleAbruptChannelClosure(TargetHandler targetHandler, HttpResponseFuture httpResponseFuture) {
        targetHandler.getOutboundRequestMsg().setIoException(new IOException("Remote host closed the connection while writing outbound request entity body"));
        httpResponseFuture.notifyHttpListener(new ClientConnectorException(this.senderReqRespStateManager.nettyTargetChannel.id().asShortText(), "Remote host closed the connection while writing outbound request entity body"));
        LOG.error("Error in HTTP client: {}", (Object)"Remote host closed the connection while writing outbound request entity body");
    }

    @Override
    public void handleIdleTimeoutConnectionClosure(TargetHandler targetHandler, HttpResponseFuture httpResponseFuture, String channelID) {
        this.senderReqRespStateManager.nettyTargetChannel.pipeline().remove("idleStateHandler");
        this.senderReqRespStateManager.nettyTargetChannel.close();
        targetHandler.getOutboundRequestMsg().setIoException(new IOException("Idle timeout triggered while writing outbound request entity body"));
        httpResponseFuture.notifyHttpListener(new EndpointTimeOutException(channelID, "Idle timeout triggered while writing outbound request entity body", HttpResponseStatus.INTERNAL_SERVER_ERROR.code()));
        LOG.error("Error in HTTP client: {}", (Object)"Idle timeout triggered while writing outbound request entity body");
    }

    private void writeOutboundRequestBody(HttpContent lastHttpContent) {
        ChannelFuture outboundRequestChannelFuture = this.senderReqRespStateManager.nettyTargetChannel.writeAndFlush(lastHttpContent);
        this.checkForRequestWriteStatus(outboundRequestChannelFuture);
    }

    private void checkForRequestWriteStatus(ChannelFuture outboundRequestChannelFuture) {
        outboundRequestChannelFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)writeOperationPromise -> {
            Throwable throwable = writeOperationPromise.cause();
            if (throwable != null) {
                if (throwable instanceof ClosedChannelException) {
                    throwable = new IOException("Connection between client and remote host is closed");
                }
                this.httpInboundResponseFuture.notifyHttpListener(throwable);
            } else {
                this.senderReqRespStateManager.state = new RequestCompleted(this.senderReqRespStateManager);
            }
        }));
    }
}

