/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender.channel;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contractimpl.common.Util;

public class BootstrapConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(BootstrapConfiguration.class);
    private boolean tcpNoDelay;
    private boolean keepAlive;
    private boolean socketReuse;
    private int connectTimeOut;
    private int receiveBufferSize;
    private int sendBufferSize;
    private int socketTimeout;

    public BootstrapConfiguration(Map<String, Object> properties) {
        this.connectTimeOut = Util.getIntProperty(properties, "client.bootstrap.connect.timeout", 15000);
        this.tcpNoDelay = Util.getBooleanProperty(properties, "client.bootstrap.nodelay", true);
        this.receiveBufferSize = Util.getIntProperty(properties, "client.bootstrap.recievebuffersize", 0x100000);
        this.sendBufferSize = Util.getIntProperty(properties, "client.bootstrap.sendbuffersize", 0x100000);
        this.socketTimeout = Util.getIntProperty(properties, "client.bootstrap.socket.timeout", 15);
        this.keepAlive = Util.getBooleanProperty(properties, "client.bootstrap.keepalive", true);
        this.socketReuse = Util.getBooleanProperty(properties, "client.bootstrap.socket.reuse", false);
        String logValue = "{}:{}";
        LOG.debug(logValue, (Object)"client.bootstrap.nodelay", (Object)this.tcpNoDelay);
        LOG.debug(logValue, (Object)"client.bootstrap.connect.timeout", (Object)this.connectTimeOut);
        LOG.debug(logValue, (Object)"client.bootstrap.recievebuffersize", (Object)this.receiveBufferSize);
        LOG.debug(logValue, (Object)"client.bootstrap.sendbuffersize", (Object)this.sendBufferSize);
        LOG.debug(logValue, (Object)"client.bootstrap.socket.timeout", (Object)this.socketTimeout);
        LOG.debug(logValue, (Object)"client.bootstrap.keepalive", (Object)this.keepAlive);
        LOG.debug(logValue, (Object)"client.bootstrap.socket.reuse", (Object)this.socketReuse);
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public int getConnectTimeOut() {
        return this.connectTimeOut;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public boolean isSocketReuse() {
        return this.socketReuse;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }
}

