/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal;

import java.text.DecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.internal.DataHolder;
import org.wso2.carbon.kernel.utils.CarbonServerInfo;

public class CarbonStartupHandler {
    private static final Logger logger = LoggerFactory.getLogger(CarbonStartupHandler.class);

    public static void logServerStartupTime() {
        double startTime = Long.parseLong(System.getProperty("carbon.start.time"));
        double startupTime = ((double)System.currentTimeMillis() - startTime) / 1000.0;
        DecimalFormat decimalFormatter = new DecimalFormat("#,##0.000");
        logger.info("WSO2 Carbon started in " + Double.valueOf(decimalFormatter.format(startupTime)) + " sec");
    }

    public static void registerCarbonServerInfoService() {
        DataHolder.getInstance().getBundleContext().registerService(CarbonServerInfo.class, (Object)new CarbonServerInfo(), null);
    }
}

